/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.join;

import com.github.parboiled1.grappa.matchers.join.JoinMatcher;
import com.google.common.annotations.Beta;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;

@Beta
public final class ExactMatchesJoinMatcher
extends JoinMatcher {
    private final int nrCycles;

    public ExactMatchesJoinMatcher(Rule joined, Rule joining, int nrCycles) {
        super(joined, joining);
        this.nrCycles = nrCycles;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (!this.joined.getSubContext(context).runMatcher()) {
            return false;
        }
        int beforeCycle = context.getCurrentIndex();
        if (!this.matchJoining(context, beforeCycle)) {
            context.setCurrentIndex(beforeCycle);
            return false;
        }
        for (int cycles = 2; cycles < this.nrCycles; ++cycles) {
            beforeCycle = context.getCurrentIndex();
            if (this.matchJoining(context, beforeCycle) && this.joined.getSubContext(context).runMatcher()) {
                continue;
            }
            context.setCurrentIndex(beforeCycle);
            return false;
        }
        context.createNode();
        return true;
    }
}

