/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.transform;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.objectweb.asm.Type;

@ParametersAreNonnullByDefault
@Immutable
public enum LdcInsnFunnel implements Funnel<Object>
{
    INSTANCE{

        public void funnel(Object from, PrimitiveSink into) {
            for (Map.Entry entry : FUNNELS.entrySet()) {
                if (!Predicates.instanceOf((Class)((Class)entry.getKey())).apply(from)) continue;
                ((Funnel)entry.getValue()).funnel(from, into);
                return;
            }
            throw new UnsupportedOperationException("unsupported class " + from.getClass().getCanonicalName());
        }
    };

    private static final Map<Class<?>, Funnel<Object>> FUNNELS;

    private static Funnel<Object> integerFunnel() {
        return new Funnel<Object>(){

            public void funnel(Object from, PrimitiveSink into) {
                into.putInt(((Integer)from).intValue());
            }
        };
    }

    private static Funnel<Object> floatFunnel() {
        return new Funnel<Object>(){

            public void funnel(Object from, PrimitiveSink into) {
                into.putFloat(((Float)from).floatValue());
            }
        };
    }

    private static Funnel<Object> longFunnel() {
        return new Funnel<Object>(){

            public void funnel(Object from, PrimitiveSink into) {
                into.putLong(((Long)from).longValue());
            }
        };
    }

    private static Funnel<Object> doubleFunnel() {
        return new Funnel<Object>(){

            public void funnel(Object from, PrimitiveSink into) {
                into.putDouble(((Double)from).doubleValue());
            }
        };
    }

    private static Funnel<Object> stringFunnel() {
        return new Funnel<Object>(){

            public void funnel(Object from, PrimitiveSink into) {
                into.putUnencodedChars((CharSequence)from);
            }
        };
    }

    private static Funnel<Object> asmTypeFunnel() {
        return new Funnel<Object>(){

            public void funnel(Object from, PrimitiveSink into) {
                Type type = (Type)from;
                into.putUnencodedChars((CharSequence)type.getInternalName());
            }
        };
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Integer.class, LdcInsnFunnel.integerFunnel()).put(Float.class, LdcInsnFunnel.floatFunnel()).put(Long.class, LdcInsnFunnel.longFunnel()).put(Double.class, LdcInsnFunnel.doubleFunnel()).put(String.class, LdcInsnFunnel.stringFunnel()).put(Type.class, LdcInsnFunnel.asmTypeFunnel());
        FUNNELS = builder.build();
    }
}

