/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.transform.asm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;

public final class ClassHelper {
    private final Type classType;
    private final boolean isInterface;
    private final int methodOpcode;
    private final ListMultimap<String, MethodDescriptor> methods = ArrayListMultimap.create();

    public ClassHelper(@Nonnull Class<?> c) {
        Preconditions.checkNotNull(c);
        this.classType = Type.getType(c);
        this.isInterface = c.isInterface();
        this.methodOpcode = this.isInterface ? 185 : 182;
        for (Method method : c.getDeclaredMethods()) {
            this.methods.put((Object)method.getName(), (Object)new MethodDescriptor(method));
        }
    }

    public MethodInsnNode methodCall(@Nonnull String name, @Nonnull Type returnType, Type ... args) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)returnType);
        Preconditions.checkNotNull((Object)args);
        MethodDescriptor descriptor = this.findMethod(name, returnType, args);
        return new MethodInsnNode(this.methodOpcode, this.classType.getInternalName(), name, descriptor.toString(), this.isInterface);
    }

    public MethodInsnNode voidMethodCall(@Nonnull String name, Type ... args) {
        return this.methodCall(name, Type.VOID_TYPE, args);
    }

    public MethodInsnNode methodCall(@Nonnull String name, @Nonnull Class<?> returnType, Class<?> ... args) {
        Preconditions.checkNotNull(returnType);
        Preconditions.checkNotNull(args);
        Type[] typeArgs = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            typeArgs[i] = Type.getType(args[i]);
        }
        return this.methodCall(name, Type.getType(returnType), typeArgs);
    }

    public MethodInsnNode voidMethodCall(@Nonnull String name, Class<?> ... args) {
        return this.methodCall(name, Void.TYPE, args);
    }

    private MethodDescriptor findMethod(String name, Type returnType, Type ... args) {
        for (MethodDescriptor descriptor : this.methods.get((Object)name)) {
            if (!returnType.equals((Object)descriptor.returnType) || !Arrays.equals(args, descriptor.args)) continue;
            return descriptor;
        }
        throw new IllegalArgumentException("no method with name " + name + ", return type " + returnType + " and arguments " + Arrays.toString(args) + " for class " + this.classType);
    }

    private static final class MethodDescriptor {
        private final Type returnType;
        private final Type[] args;

        private MethodDescriptor(Method method) {
            this.returnType = Type.getReturnType((Method)method);
            this.args = Type.getArgumentTypes((Method)method);
        }

        public String toString() {
            return Type.getMethodDescriptor((Type)this.returnType, (Type[])this.args);
        }
    }
}

