/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.transform.asm;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

@Immutable
public final class MethodDescriptor {
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final Function<Type, String> TO_DESCRIPTOR = new Function<Type, String>(){

        public String apply(Type input) {
            return input.getDescriptor();
        }
    };
    private final int access;
    private final Type returnType;
    private final List<Type> arguments;

    public static Builder newBuilder() {
        return new Builder();
    }

    private MethodDescriptor(Builder builder) {
        this.access = builder.access;
        this.returnType = builder.returnType;
        this.arguments = ImmutableList.copyOf((Collection)builder.arguments);
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        JOINER.appendTo(sb, Iterables.transform(this.arguments, TO_DESCRIPTOR));
        sb.append(')').append(this.returnType.getDescriptor());
        return sb.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        private int access = 1;
        private Type returnType = Type.VOID_TYPE;
        private final List<Type> arguments = Lists.newArrayList();

        private Builder() {
        }

        public Builder withAccess(int access) {
            this.access = access;
            return this;
        }

        public Builder withReturnType(@Nonnull Type returnType) {
            Preconditions.checkNotNull((Object)returnType);
            this.returnType = returnType;
            return this;
        }

        public Builder withReturnType(@Nonnull Class<?> c) {
            Preconditions.checkNotNull(c);
            return this.withReturnType(Type.getType(c));
        }

        public Builder addArgument(@Nonnull Type type) {
            Preconditions.checkNotNull((Object)type);
            this.arguments.add(type);
            return this;
        }

        public Builder addArgument(@Nonnull Class<?> c) {
            Preconditions.checkNotNull(c);
            return this.addArgument(Type.getType(c));
        }

        public Builder fromMethodNode(@Nonnull MethodNode node) {
            String descriptor = node.desc;
            this.returnType = Type.getReturnType((String)descriptor);
            this.arguments.clear();
            this.arguments.addAll(Arrays.asList(Type.getArgumentTypes((String)descriptor)));
            this.access = node.access;
            return this;
        }

        public MethodDescriptor build() {
            return new MethodDescriptor(this);
        }
    }
}

