/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import com.github.parboiled1.grappa.matchers.join.JoinMatcherBootstrap;
import com.github.parboiled1.grappa.matchers.trie.Trie;
import com.github.parboiled1.grappa.matchers.trie.TrieBuilder;
import com.github.parboiled1.grappa.matchers.trie.TrieMatcher;
import com.github.parboiled1.grappa.matchers.unicode.UnicodeCharMatcher;
import com.github.parboiled1.grappa.matchers.unicode.UnicodeRangeMatcher;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.Action;
import org.parboiled.BaseActions;
import org.parboiled.Rule;
import org.parboiled.annotations.Cached;
import org.parboiled.annotations.DontExtend;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;
import org.parboiled.errors.GrammarException;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.AnyMatcher;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.FirstOfStringsMatcher;
import org.parboiled.matchers.NothingMatcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.StringMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.support.Characters;
import org.parboiled.support.Checks;

public abstract class BaseParser<V>
extends BaseActions<V> {
    public static final Rule EOI = new CharMatcher('\uffff');
    public static final Rule INDENT = new CharMatcher('\ufdd0');
    public static final Rule DEDENT = new CharMatcher('\ufdd1');
    public static final Rule ANY = new AnyMatcher();
    public static final Rule EMPTY = new EmptyMatcher();
    public static final Rule NOTHING = new NothingMatcher();

    public <P extends BaseParser<V>> P newInstance() {
        throw new UnsupportedOperationException("Illegal parser instance, you have to use Parboiled.createParser(...) to create your parser instance!");
    }

    @Cached
    @DontLabel
    public Rule ch(char c) {
        return new CharMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule ignoreCase(char c) {
        return Character.isLowerCase(c) == Character.isUpperCase(c) ? this.ch(c) : new CharIgnoreCaseMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule unicodeChar(int codePoint) {
        com.google.common.base.Preconditions.checkArgument((boolean)Character.isValidCodePoint(codePoint), (Object)("invalid code point " + codePoint));
        return UnicodeCharMatcher.forCodePoint(codePoint);
    }

    @Cached
    @DontLabel
    public Rule unicodeRange(int low, int high) {
        com.google.common.base.Preconditions.checkArgument((boolean)Character.isValidCodePoint(low), (Object)("invalid code point " + low));
        com.google.common.base.Preconditions.checkArgument((boolean)Character.isValidCodePoint(high), (Object)("invalid code point " + high));
        com.google.common.base.Preconditions.checkArgument((low <= high ? 1 : 0) != 0, (Object)("invalid range: " + low + " > " + high));
        return low == high ? UnicodeCharMatcher.forCodePoint(low) : UnicodeRangeMatcher.forRange(low, high);
    }

    @Cached
    @DontLabel
    public Rule charRange(char cLow, char cHigh) {
        return cLow == cHigh ? this.ch(cLow) : new CharRangeMatcher(cLow, cHigh);
    }

    @DontLabel
    public Rule anyOf(@Nonnull String characters) {
        com.google.common.base.Preconditions.checkNotNull((Object)characters, (Object)"characters");
        return this.anyOf(characters.toCharArray());
    }

    @DontLabel
    public Rule anyOf(@Nonnull char[] characters) {
        com.google.common.base.Preconditions.checkNotNull((Object)characters, (Object)"characters");
        com.google.common.base.Preconditions.checkArgument((characters.length > 0 ? 1 : 0) != 0);
        return characters.length == 1 ? this.ch(characters[0]) : this.anyOf(Characters.of(characters));
    }

    @Cached
    @DontLabel
    public Rule anyOf(@Nonnull Characters characters) {
        com.google.common.base.Preconditions.checkNotNull((Object)characters, (Object)"characters");
        if (!characters.isSubtractive() && characters.getChars().length == 1) {
            return this.ch(characters.getChars()[0]);
        }
        if (characters.equals(Characters.NONE)) {
            return NOTHING;
        }
        return new AnyOfMatcher(characters);
    }

    @DontLabel
    public Rule noneOf(@Nonnull String characters) {
        com.google.common.base.Preconditions.checkNotNull((Object)characters, (Object)"characters");
        return this.noneOf(characters.toCharArray());
    }

    @DontLabel
    public Rule noneOf(@Nonnull char[] characters) {
        com.google.common.base.Preconditions.checkNotNull((Object)characters, (Object)"characters");
        com.google.common.base.Preconditions.checkArgument((characters.length > 0 ? 1 : 0) != 0);
        boolean containsEOI = false;
        for (char c : characters) {
            if (c != '\uffff') continue;
            containsEOI = true;
            break;
        }
        if (!containsEOI) {
            char[] withEOI = new char[characters.length + 1];
            System.arraycopy(characters, 0, withEOI, 0, characters.length);
            withEOI[characters.length] = 65535;
            characters = withEOI;
        }
        return this.anyOf(Characters.allBut(characters));
    }

    @DontLabel
    public Rule string(@Nonnull String string) {
        com.google.common.base.Preconditions.checkNotNull((Object)string, (Object)"string");
        return this.string(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule string(char ... characters) {
        if (characters.length == 1) {
            return this.ch(characters[0]);
        }
        Rule[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.ch(characters[i]);
        }
        return new StringMatcher(matchers, characters);
    }

    @DontLabel
    public Rule ignoreCase(@Nonnull String string) {
        com.google.common.base.Preconditions.checkNotNull((Object)string, (Object)"string");
        return this.ignoreCase(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule ignoreCase(char ... characters) {
        if (characters.length == 1) {
            return this.ignoreCase(characters[0]);
        }
        Rule[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.ignoreCase(characters[i]);
        }
        return new SequenceMatcher(matchers).label('\"' + String.valueOf(characters) + '\"');
    }

    @Cached
    public Rule trie(@Nonnull Collection<String> strings) {
        ImmutableList list = ImmutableList.copyOf(strings);
        TrieBuilder builder = Trie.newBuilder();
        for (String word : list) {
            builder.addWord(word);
        }
        return new TrieMatcher(builder.build());
    }

    public Rule trie(@Nonnull String first, @Nonnull String second, String ... others) {
        ImmutableList words = ImmutableList.builder().add((Object)first).add((Object)second).add((Object[])others).build();
        return this.trie((Collection<String>)words);
    }

    @DontLabel
    public Rule firstOf(@Nonnull Object rule, @Nonnull Object rule2, Object ... moreRules) {
        com.google.common.base.Preconditions.checkNotNull((Object)moreRules, (Object)"moreRules");
        Object[] rules = ImmutableList.builder().add(rule).add(rule2).add(moreRules).build().toArray();
        return this.firstOf(rules);
    }

    @Cached
    @DontLabel
    public Rule firstOf(@Nonnull Object[] rules) {
        com.google.common.base.Preconditions.checkNotNull((Object)rules, (Object)"rules");
        if (rules.length == 1) {
            return this.toRule(rules[0]);
        }
        Rule[] convertedRules = this.toRules(rules);
        int len = convertedRules.length;
        char[][] chars = new char[rules.length][];
        for (int i = 0; i < len; ++i) {
            Rule rule = convertedRules[i];
            if (!(rule instanceof StringMatcher)) {
                return new FirstOfMatcher(convertedRules);
            }
            chars[i] = ((StringMatcher)rule).characters;
        }
        return new FirstOfStringsMatcher(convertedRules, chars);
    }

    @Cached
    @DontLabel
    public Rule oneOrMore(@Nonnull Object rule) {
        return new OneOrMoreMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule oneOrMore(@Nonnull Object rule, @Nonnull Object rule2, Object ... moreRules) {
        com.google.common.base.Preconditions.checkNotNull((Object)moreRules, (Object)"moreRules");
        return this.oneOrMore(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule optional(@Nonnull Object rule) {
        com.google.common.base.Preconditions.checkNotNull((Object)rule);
        return new OptionalMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule optional(@Nonnull Object rule, @Nonnull Object rule2, Object ... moreRules) {
        com.google.common.base.Preconditions.checkNotNull((Object)moreRules, (Object)"moreRules");
        return this.optional(this.sequence(rule, rule2, moreRules));
    }

    @DontLabel
    public Rule sequence(@Nonnull Object rule, @Nonnull Object rule2, Object ... moreRules) {
        com.google.common.base.Preconditions.checkNotNull((Object)moreRules, (Object)"moreRules");
        Object[] rules = ImmutableList.builder().add(rule).add(rule2).add(moreRules).build().toArray();
        return this.sequence(rules);
    }

    @Cached
    @DontLabel
    public Rule sequence(@Nonnull Object[] rules) {
        com.google.common.base.Preconditions.checkNotNull((Object)rules, (Object)"rules");
        return rules.length == 1 ? this.toRule(rules[0]) : new SequenceMatcher(this.toRules(rules));
    }

    public final JoinMatcherBootstrap<V, BaseParser<V>> join(Object joined) {
        return new JoinMatcherBootstrap(this, joined);
    }

    @Cached
    @SuppressNode
    @DontLabel
    public Rule test(@Nonnull Object rule) {
        Rule subMatcher = this.toRule(rule);
        return new TestMatcher(subMatcher);
    }

    @DontLabel
    public Rule test(@Nonnull Object rule, @Nonnull Object rule2, Object ... moreRules) {
        com.google.common.base.Preconditions.checkNotNull((Object)moreRules, (Object)"moreRules");
        return this.test(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @SuppressNode
    @DontLabel
    public Rule testNot(@Nonnull Object rule) {
        return new TestNotMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule testNot(@Nonnull Object rule, @Nonnull Object rule2, Object ... moreRules) {
        com.google.common.base.Preconditions.checkNotNull((Object)moreRules, (Object)"moreRules");
        return this.testNot(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule zeroOrMore(@Nonnull Object rule) {
        return new ZeroOrMoreMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule zeroOrMore(@Nonnull Object rule, @Nonnull Object rule2, Object ... moreRules) {
        com.google.common.base.Preconditions.checkNotNull((Object)moreRules, (Object)"moreRules");
        return this.zeroOrMore(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule nTimes(int repetitions, @Nonnull Object rule) {
        return this.nTimes(repetitions, rule, null);
    }

    @Cached
    @DontLabel
    public Rule nTimes(int repetitions, @Nonnull Object rule, @Nullable Object separator) {
        com.google.common.base.Preconditions.checkNotNull((Object)rule, (Object)"rule");
        com.google.common.base.Preconditions.checkArgument((repetitions >= 0 ? 1 : 0) != 0, (Object)"repetitions must be non-negative");
        if (repetitions == 0) {
            return EMPTY;
        }
        if (repetitions == 1) {
            return this.toRule(rule);
        }
        ImmutableList.Builder builder = ImmutableList.builder().add(rule);
        int size = separator == null ? repetitions - 1 : (repetitions - 1) * 2;
        FluentIterable iterable = FluentIterable.from(Arrays.asList(separator, rule)).filter(Predicates.notNull()).cycle().limit(size);
        for (Object o : iterable) {
            builder.add((Object)this.toRule(o));
        }
        return this.sequence(builder.build().toArray());
    }

    public Rule alpha() {
        return this.firstOf(this.charRange('a', 'z'), this.charRange('A', 'Z'), new Object[0]);
    }

    public Rule bit() {
        return this.anyOf(Characters.of('0', '1'));
    }

    public Rule asciiChars() {
        return this.charRange('\u0001', '\u007f');
    }

    public Rule cr() {
        return this.ch('\r');
    }

    public Rule crlf() {
        return this.string("\r\n");
    }

    public Rule ctl() {
        return this.firstOf(this.charRange('\u0000', '\u001f'), this.ch('\u007f'), new Object[0]);
    }

    public Rule digit() {
        return this.charRange('0', '9');
    }

    public Rule dquote() {
        return this.ch('\"');
    }

    public Rule hexDigit() {
        return this.anyOf("ABCDEFabcdef0123456789");
    }

    public Rule hexDigitUpperCase() {
        return this.anyOf("ABCDEF0123456789");
    }

    public Rule hexDigitLowerCase() {
        return this.anyOf("abcdef0123456789");
    }

    public Rule hTab() {
        return this.ch('\t');
    }

    public Rule lf() {
        return this.ch('\n');
    }

    public Rule octet() {
        return this.charRange('\u0000', '\u00ff');
    }

    public Rule sp() {
        return this.ch(' ');
    }

    public Rule vchar() {
        return this.charRange('!', '~');
    }

    public Rule wsp() {
        return this.anyOf(" \t");
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule Ch(char c) {
        return new CharMatcher(c);
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule IgnoreCase(char c) {
        if (Character.isLowerCase(c) == Character.isUpperCase(c)) {
            return this.Ch(c);
        }
        return new CharIgnoreCaseMatcher(c);
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule UnicodeChar(int codePoint) {
        Preconditions.checkArgument(Character.isValidCodePoint(codePoint), "invalid code point " + codePoint);
        return UnicodeCharMatcher.forCodePoint(codePoint);
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule UnicodeRange(int low, int high) {
        Preconditions.checkArgument(Character.isValidCodePoint(low), "invalid code point " + low);
        Preconditions.checkArgument(Character.isValidCodePoint(high), "invalid code point " + high);
        Preconditions.checkArgument(low <= high, "invalid range: " + low + " > " + high);
        return low == high ? UnicodeCharMatcher.forCodePoint(low) : UnicodeRangeMatcher.forRange(low, high);
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule CharRange(char cLow, char cHigh) {
        return cLow == cHigh ? this.Ch(cLow) : new CharRangeMatcher(cLow, cHigh);
    }

    @Deprecated
    @DontLabel
    public Rule AnyOf(String characters) {
        Preconditions.checkArgNotNull(characters, "characters");
        return this.AnyOf(characters.toCharArray());
    }

    @Deprecated
    @DontLabel
    public Rule AnyOf(char[] characters) {
        com.google.common.base.Preconditions.checkNotNull((Object)characters, (Object)"characters");
        com.google.common.base.Preconditions.checkArgument((characters.length > 0 ? 1 : 0) != 0);
        return characters.length == 1 ? this.Ch(characters[0]) : this.AnyOf(Characters.of(characters));
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule AnyOf(Characters characters) {
        Preconditions.checkArgNotNull(characters, "characters");
        if (!characters.isSubtractive() && characters.getChars().length == 1) {
            return this.Ch(characters.getChars()[0]);
        }
        if (characters.equals(Characters.NONE)) {
            return NOTHING;
        }
        return new AnyOfMatcher(characters);
    }

    @Deprecated
    @DontLabel
    public Rule NoneOf(String characters) {
        Preconditions.checkArgNotNull(characters, "characters");
        return this.NoneOf(characters.toCharArray());
    }

    @Deprecated
    @DontLabel
    public Rule NoneOf(char[] characters) {
        Preconditions.checkArgNotNull(characters, "characters");
        Preconditions.checkArgument(characters.length > 0);
        boolean containsEOI = false;
        for (char c : characters) {
            if (c != '\uffff') continue;
            containsEOI = true;
            break;
        }
        if (!containsEOI) {
            char[] withEOI = new char[characters.length + 1];
            System.arraycopy(characters, 0, withEOI, 0, characters.length);
            withEOI[characters.length] = 65535;
            characters = withEOI;
        }
        return this.AnyOf(Characters.allBut(characters));
    }

    @Deprecated
    @DontLabel
    public Rule String(String string) {
        Preconditions.checkArgNotNull(string, "string");
        return this.String(string.toCharArray());
    }

    @Deprecated
    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule String(char ... characters) {
        if (characters.length == 1) {
            return this.Ch(characters[0]);
        }
        Rule[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.Ch(characters[i]);
        }
        return new StringMatcher(matchers, characters);
    }

    @Deprecated
    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule IgnoreCase(char ... characters) {
        if (characters.length == 1) {
            return this.IgnoreCase(characters[0]);
        }
        Object[] matchers = new Rule[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            matchers[i] = this.IgnoreCase(characters[i]);
        }
        return ((SequenceMatcher)this.Sequence(matchers)).label('\"' + String.valueOf(characters) + '\"');
    }

    @Deprecated
    @DontLabel
    public Rule IgnoreCase(String string) {
        Preconditions.checkArgNotNull(string, "string");
        return this.IgnoreCase(string.toCharArray());
    }

    @Deprecated
    @DontLabel
    public Rule FirstOf(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull(moreRules, "moreRules");
        return this.FirstOf(Utils.arrayOf(rule, rule2, moreRules));
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule FirstOf(Object[] rules) {
        Preconditions.checkArgNotNull(rules, "rules");
        if (rules.length == 1) {
            return this.toRule(rules[0]);
        }
        Rule[] convertedRules = this.toRules(rules);
        char[][] chars = new char[rules.length][];
        int convertedRulesLength = convertedRules.length;
        for (int i = 0; i < convertedRulesLength; ++i) {
            Rule rule = convertedRules[i];
            if (!(rule instanceof StringMatcher)) {
                return new FirstOfMatcher(convertedRules);
            }
            chars[i] = ((StringMatcher)rule).characters;
        }
        return new FirstOfStringsMatcher(convertedRules, chars);
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule OneOrMore(Object rule) {
        return new OneOrMoreMatcher(this.toRule(rule));
    }

    @Deprecated
    @DontLabel
    public Rule OneOrMore(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull(moreRules, "moreRules");
        return this.OneOrMore(this.Sequence(rule, rule2, moreRules));
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule Optional(Object rule) {
        return new OptionalMatcher(this.toRule(rule));
    }

    @Deprecated
    @DontLabel
    public Rule Optional(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull(moreRules, "moreRules");
        return this.Optional(this.Sequence(rule, rule2, moreRules));
    }

    @Deprecated
    @DontLabel
    public Rule Sequence(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull(moreRules, "moreRules");
        return this.Sequence(Utils.arrayOf(rule, rule2, moreRules));
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule Sequence(Object[] rules) {
        Preconditions.checkArgNotNull(rules, "rules");
        return rules.length == 1 ? this.toRule(rules[0]) : new SequenceMatcher(this.toRules(rules));
    }

    @Deprecated
    @Cached
    @SuppressNode
    @DontLabel
    public Rule Test(Object rule) {
        Rule subMatcher = this.toRule(rule);
        return new TestMatcher(subMatcher);
    }

    @Deprecated
    @DontLabel
    public Rule Test(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull(moreRules, "moreRules");
        return this.Test(this.Sequence(rule, rule2, moreRules));
    }

    @Deprecated
    @Cached
    @SuppressNode
    @DontLabel
    public Rule TestNot(Object rule) {
        Rule subMatcher = this.toRule(rule);
        return new TestNotMatcher(subMatcher);
    }

    @Deprecated
    @DontLabel
    public Rule TestNot(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull(moreRules, "moreRules");
        return this.TestNot(this.Sequence(rule, rule2, moreRules));
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule ZeroOrMore(Object rule) {
        return new ZeroOrMoreMatcher(this.toRule(rule));
    }

    @Deprecated
    @DontLabel
    public Rule ZeroOrMore(Object rule, Object rule2, Object ... moreRules) {
        Preconditions.checkArgNotNull(moreRules, "moreRules");
        return this.ZeroOrMore(this.Sequence(rule, rule2, moreRules));
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule NTimes(int repetitions, Object rule) {
        return this.NTimes(repetitions, rule, null);
    }

    @Deprecated
    @Cached
    @DontLabel
    public Rule NTimes(int repetitions, Object rule, Object separator) {
        Preconditions.checkArgNotNull(rule, "rule");
        Preconditions.checkArgument(repetitions >= 0, "repetitions must be non-negative");
        switch (repetitions) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return this.toRule(rule);
            }
        }
        Object[] rules = new Object[separator == null ? repetitions : repetitions * 2 - 1];
        if (separator != null) {
            for (int i = 0; i < rules.length; ++i) {
                rules[i] = i % 2 == 0 ? rule : separator;
            }
        } else {
            Arrays.fill(rules, rule);
        }
        return this.Sequence(rules);
    }

    public static <T> Action<T> ACTION(boolean expression) {
        throw new UnsupportedOperationException("ACTION(...) calls can only be used in Rule creating parser methods");
    }

    @DontExtend
    protected Rule fromCharLiteral(char c) {
        return this.ch(c);
    }

    @DontExtend
    protected Rule fromStringLiteral(@Nonnull String string) {
        com.google.common.base.Preconditions.checkNotNull((Object)string, (Object)"string");
        return this.fromCharArray(string.toCharArray());
    }

    @DontExtend
    protected Rule fromCharArray(@Nonnull char[] array) {
        com.google.common.base.Preconditions.checkNotNull((Object)array, (Object)"array");
        return this.string(array);
    }

    @DontExtend
    public Rule[] toRules(Object ... objects) {
        com.google.common.base.Preconditions.checkNotNull((Object)objects, (Object)"objects");
        Rule[] rules = new Rule[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            rules[i] = this.toRule(objects[i]);
        }
        return rules;
    }

    @DontExtend
    public Rule toRule(@Nonnull Object obj) {
        if (obj instanceof Rule) {
            return (Rule)obj;
        }
        if (obj instanceof Character) {
            return this.fromCharLiteral(((Character)obj).charValue());
        }
        if (obj instanceof String) {
            return this.fromStringLiteral((String)obj);
        }
        if (obj instanceof char[]) {
            return this.fromCharArray((char[])obj);
        }
        if (obj instanceof Action) {
            Action action = (Action)obj;
            return new ActionMatcher(action);
        }
        Checks.ensure(!(obj instanceof Boolean), "Rule specification contains an unwrapped Boolean value, if you were trying to specify a parser action wrap the expression with ACTION(...)");
        throw new GrammarException("'" + obj + "' cannot be automatically " + "converted to a parser Rule");
    }
}

