/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.parboiled.Context;
import org.parboiled.DefaultParsingNode;
import org.parboiled.MatchHandler;
import org.parboiled.Node;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.BasicParseError;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.GrammarException;
import org.parboiled.errors.ParseError;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MatcherUtils;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.support.CharsEscaper;
import org.parboiled.support.Checks;
import org.parboiled.support.IndexRange;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.MatcherPosition;
import org.parboiled.support.ParseTreeUtils;
import org.parboiled.support.Position;
import org.parboiled.support.ValueStack;

public class MatcherContext<V>
implements Context<V> {
    private final InputBuffer inputBuffer;
    private final ValueStack<V> valueStack;
    private final List<ParseError> parseErrors;
    private final MatchHandler matchHandler;
    private final MatcherContext<V> parent;
    private final int level;
    private final boolean fastStringMatching;
    private final Set<MatcherPosition> memoizedMismatches;
    private MatcherContext<V> subContext;
    private int startIndex;
    private int currentIndex;
    private char currentChar;
    private Matcher matcher;
    private Node<V> node;
    private List<Node<V>> subNodes = Lists.newArrayList();
    private MatcherPath path;
    private int intTag;
    private boolean hasError;
    private boolean nodeSuppressed;
    private boolean inErrorRecovery;

    public MatcherContext(@Nonnull InputBuffer inputBuffer, @Nonnull ValueStack<V> valueStack, @Nonnull List<ParseError> parseErrors, @Nonnull MatchHandler matchHandler, @Nonnull Matcher matcher, boolean fastStringMatching) {
        this((InputBuffer)Preconditions.checkNotNull((Object)inputBuffer, (Object)"inputBuffer"), (ValueStack)Preconditions.checkNotNull(valueStack, (Object)"valueStack"), (List)Preconditions.checkNotNull(parseErrors, (Object)"parseErrors"), (MatchHandler)Preconditions.checkNotNull((Object)matchHandler, (Object)"matchHandler"), null, 0, fastStringMatching, new HashSet<MatcherPosition>());
        this.currentChar = inputBuffer.charAt(0);
        Preconditions.checkNotNull((Object)matcher);
        this.matcher = ProxyMatcher.unwrap(matcher);
        this.nodeSuppressed = matcher.isNodeSuppressed();
    }

    private MatcherContext(InputBuffer inputBuffer, ValueStack<V> valueStack, List<ParseError> parseErrors, MatchHandler matchHandler, MatcherContext<V> parent, int level, boolean fastStringMatching, Set<MatcherPosition> memoizedMismatches) {
        this.inputBuffer = inputBuffer;
        this.valueStack = valueStack;
        this.parseErrors = parseErrors;
        this.matchHandler = matchHandler;
        this.parent = parent;
        this.level = level;
        this.fastStringMatching = fastStringMatching;
        this.memoizedMismatches = memoizedMismatches;
    }

    public String toString() {
        return this.getPath().toString();
    }

    @Override
    public MatcherContext<V> getParent() {
        return this.parent;
    }

    @Override
    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public char getCurrentChar() {
        return this.currentChar;
    }

    @Override
    public List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public MatcherPath getPath() {
        if (this.path != null) {
            return this.path;
        }
        this.path = new MatcherPath(new MatcherPath.Element(this.matcher, this.startIndex, this.level), this.parent != null ? this.parent.getPath() : null);
        return this.path;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean fastStringMatching() {
        return this.fastStringMatching;
    }

    @Override
    @Nonnull
    public List<Node<V>> getSubNodes() {
        if (this.matcher.isNodeSkipped()) {
            return this.subNodes;
        }
        ArrayDeque remaining = Queues.newArrayDeque(this.subNodes);
        ArrayList ret = Lists.newArrayList();
        MatcherContext.collectSubNodes(remaining, ret);
        Collections.reverse(ret);
        return ret;
    }

    private static <E> void collectSubNodes(Deque<Node<E>> remaining, List<Node<E>> into) {
        while (!remaining.isEmpty()) {
            Node<E> head = remaining.pop();
            if (!head.getMatcher().isNodeSkipped()) {
                into.add(head);
                continue;
            }
            MatcherContext.collectSubNodes(Queues.newArrayDeque(head.getChildren()), into);
        }
    }

    @Override
    public boolean inPredicate() {
        if (this.matcher instanceof TestMatcher) {
            return true;
        }
        if (this.matcher instanceof TestNotMatcher) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.inPredicate();
    }

    @Override
    public boolean inErrorRecovery() {
        return this.inErrorRecovery;
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.nodeSuppressed;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public String getMatch() {
        this.checkActionContext();
        MatcherContext<V> prevContext = this.subContext;
        if (!this.hasError) {
            return this.inputBuffer.extract(prevContext.startIndex, prevContext.currentIndex);
        }
        Node<V> prevNode = prevContext.node;
        return prevNode != null ? ParseTreeUtils.getNodeText(prevNode, this.inputBuffer) : "";
    }

    @Override
    public char getFirstMatchChar() {
        this.checkActionContext();
        int index = this.subContext.startIndex;
        if (this.subContext.currentIndex > index) {
            return this.inputBuffer.charAt(index);
        }
        throw new GrammarException("getFirstMatchChar called but previous rule did not match anything");
    }

    @Override
    public int getMatchStartIndex() {
        this.checkActionContext();
        return this.subContext.startIndex;
    }

    @Override
    public int getMatchEndIndex() {
        this.checkActionContext();
        return this.subContext.currentIndex;
    }

    @Override
    public int getMatchLength() {
        this.checkActionContext();
        return this.subContext.currentIndex - this.subContext.getStartIndex();
    }

    @Override
    public Position getPosition() {
        return this.inputBuffer.getPosition(this.currentIndex);
    }

    @Override
    public IndexRange getMatchRange() {
        this.checkActionContext();
        return new IndexRange(this.subContext.startIndex, this.subContext.currentIndex);
    }

    private void checkActionContext() {
        boolean condition = MatcherUtils.unwrap(this.matcher) instanceof SequenceMatcher && this.intTag > 0 && this.subContext.matcher instanceof ActionMatcher;
        Checks.ensure(condition, "Illegal call to getMatch(), getMatchStartIndex(), getMatchEndIndex() or getMatchRange(), only valid in Sequence rule actions that are not in first position");
    }

    @Override
    public ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public void setStartIndex(int startIndex) {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0);
        this.startIndex = startIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        Preconditions.checkArgument((currentIndex >= 0 ? 1 : 0) != 0);
        this.currentIndex = currentIndex;
        this.currentChar = this.inputBuffer.charAt(currentIndex);
    }

    public void setInErrorRecovery(boolean flag) {
        this.inErrorRecovery = flag;
    }

    public void advanceIndex(int delta) {
        this.currentIndex += delta;
        this.currentChar = this.inputBuffer.charAt(this.currentIndex);
    }

    public Node<V> getNode() {
        return this.node;
    }

    public int getIntTag() {
        return this.intTag;
    }

    public void setIntTag(int intTag) {
        this.intTag = intTag;
    }

    public void markError() {
        if (this.hasError) {
            return;
        }
        this.hasError = true;
        if (this.parent != null) {
            this.parent.markError();
        }
    }

    public Boolean hasMismatched() {
        return this.memoizedMismatches.contains(MatcherPosition.at(this.matcher, this.currentIndex));
    }

    public void memoizeMismatch() {
        this.memoizedMismatches.add(MatcherPosition.at(this.matcher, this.currentIndex));
    }

    public void createNode() {
        if (this.nodeSuppressed) {
            return;
        }
        this.node = new DefaultParsingNode<Object>(this.matcher, (List<Node<Object>>)this.getSubNodes(), this.startIndex, this.currentIndex, (this.valueStack.isEmpty() ? null : (Object)this.valueStack.peek()), this.hasError);
        if (this.parent != null) {
            this.parent.subNodes.add(0, this.node);
        }
    }

    public final MatcherContext<V> getBasicSubContext() {
        if (this.subContext == null) {
            this.subContext = new MatcherContext<V>(this.inputBuffer, this.valueStack, this.parseErrors, this.matchHandler, this, this.level + 1, this.fastStringMatching, this.memoizedMismatches);
        } else {
            this.subContext.path = null;
        }
        return this.subContext;
    }

    public final MatcherContext<V> getSubContext(Matcher matcher) {
        MatcherContext<V> sc = this.getBasicSubContext();
        sc.matcher = matcher;
        sc.startIndex = sc.currentIndex = this.currentIndex;
        sc.currentChar = this.currentChar;
        sc.node = null;
        sc.subNodes = Lists.newArrayList();
        sc.nodeSuppressed = this.nodeSuppressed || this.matcher.areSubnodesSuppressed() || matcher.isNodeSuppressed();
        sc.hasError = false;
        return sc;
    }

    public boolean runMatcher() {
        try {
            boolean ret = this.matchHandler.match(this);
            this.matcher = null;
            if (ret && this.parent != null) {
                this.parent.currentIndex = this.currentIndex;
                this.parent.currentChar = this.currentChar;
            }
            return ret;
        }
        catch (ParserRuntimeException e) {
            throw e;
        }
        catch (RecoveringParseRunner.TimeoutException e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = String.format("Error while parsing %s '%s' at input position\n%s", this.matcher instanceof ActionMatcher ? "action" : "rule", this.getPath(), e);
            BasicParseError error = new BasicParseError(this.inputBuffer, this.currentIndex, CharsEscaper.INSTANCE.escape(msg));
            throw new ParserRuntimeException(e, ErrorUtils.printParseError(error), new Object[0]);
        }
    }
}

