/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.IntArrayStack;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

@Immutable
public final class CharSequenceInputBuffer
implements InputBuffer {
    private final CharSequence charSequence;
    private final AtomicBoolean newlinesAreBuilt = new AtomicBoolean(false);
    @GuardedBy(value="newlinesAreBuilt")
    private int[] newlines;

    public CharSequenceInputBuffer(@Nonnull CharSequence charSequence) {
        this.charSequence = (CharSequence)Preconditions.checkNotNull((Object)charSequence);
    }

    @Override
    public char charAt(int index) {
        return index >= 0 && index < this.charSequence.length() ? this.charSequence.charAt(index) : (char)'\uffff';
    }

    @Override
    public boolean test(int index, char[] characters) {
        int length = characters.length;
        if (index + length > this.charSequence.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.charSequence.charAt(index + i) == characters[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String extract(int start, int end) {
        int realStart = Math.max(start, 0);
        int realEnd = Math.min(end, this.charSequence.length());
        return ((Object)this.charSequence.subSequence(realStart, realEnd)).toString();
    }

    @Override
    public String extract(IndexRange range) {
        return this.extract(range.start, range.end);
    }

    @Override
    public Position getPosition(int index) {
        int line;
        if (!this.newlinesAreBuilt.getAndSet(true)) {
            this.buildNewlines();
        }
        int column = (line = CharSequenceInputBuffer.getLineNumber(this.newlines, index)) == 0 ? index + 1 : index - this.newlines[line - 1];
        return new Position(line + 1, column);
    }

    @Override
    public int getOriginalIndex(int index) {
        return index;
    }

    @Override
    public String extractLine(int lineNumber) {
        int end;
        if (!this.newlinesAreBuilt.getAndSet(true)) {
            this.buildNewlines();
        }
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (Object)"line number is negative");
        Preconditions.checkArgument((lineNumber <= this.newlines.length + 1 ? 1 : 0) != 0, (Object)"line index out of range");
        int start = lineNumber > 1 ? this.newlines[lineNumber - 2] + 1 : 0;
        int n = end = lineNumber <= this.newlines.length ? this.newlines[lineNumber - 1] : this.charSequence.length();
        if (this.charAt(end - 1) == '\r') {
            --end;
        }
        return this.extract(start, end);
    }

    @Override
    public int getLineCount() {
        if (!this.newlinesAreBuilt.getAndSet(true)) {
            this.buildNewlines();
        }
        return this.newlines.length + 1;
    }

    private void buildNewlines() {
        IntArrayStack stack = new IntArrayStack();
        for (int i = 0; i < this.charSequence.length(); ++i) {
            if (this.charSequence.charAt(i) != '\n') continue;
            stack.push(i);
        }
        this.newlines = new int[stack.size()];
        stack.getElements(this.newlines, 0);
    }

    private static int getLineNumber(int[] newlines, int index) {
        int ret = Arrays.binarySearch(newlines, index);
        return ret >= 0 ? ret : -(ret + 1);
    }
}

