/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

public class IntArrayStack {
    private static final int INITIAL_CAPACITY = 16;
    private int[] array = new int[16];
    private int top = -1;

    public boolean isEmpty() {
        return this.top == -1;
    }

    public int size() {
        return this.top + 1;
    }

    public void getElements(int[] destArray, int destStartIndex) {
        System.arraycopy(this.array, 0, destArray, destStartIndex, this.size());
    }

    public int[] toArray() {
        int[] ret = new int[this.size()];
        this.getElements(ret, 0);
        return ret;
    }

    public void clear() {
        this.top = -1;
    }

    public int peek() {
        if (this.isEmpty()) {
            throw new UnderflowException("IntArrayStack peek");
        }
        return this.array[this.top];
    }

    public int pop() {
        if (this.isEmpty()) {
            throw new UnderflowException("IntArrayStack pop");
        }
        return this.array[this.top--];
    }

    public void push(int x) {
        if (this.top == this.array.length - 1) {
            this.expandCapacity();
        }
        this.array[++this.top] = x;
    }

    private void expandCapacity() {
        int[] newArray = new int[this.array.length * 2];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
    }

    public static class UnderflowException
    extends RuntimeException {
        public UnderflowException(String message) {
            super(message);
        }
    }
}

