/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import org.parboiled.MatcherContext;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.support.Chars;

public class CharMatcher
extends AbstractMatcher {
    public final char character;

    public CharMatcher(char character) {
        super(CharMatcher.getLabel(character));
        this.character = character;
    }

    private static String getLabel(char c) {
        switch (c) {
            case '\ufdd0': 
            case '\ufdd1': 
            case '\ufdea': 
            case '\ufdeb': 
            case '\ufdec': 
            case '\ufded': 
            case '\ufdee': 
            case '\ufdef': 
            case '\uffff': {
                return Chars.escape(c);
            }
        }
        return '\'' + Chars.escape(c) + '\'';
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (context.getCurrentChar() != this.character) {
            return false;
        }
        context.advanceIndex(1);
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, (Object)"visitor");
        return visitor.visit(this);
    }
}

