/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import com.github.parboiled1.grappa.stack.DefaultValueStack;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.CharSequenceInputBuffer;
import org.parboiled.buffers.DefaultInputBuffer;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.Matcher;
import org.parboiled.parserunners.ParseRunner;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.ValueStack;

public abstract class AbstractParseRunner<V>
implements ParseRunner<V> {
    private final Matcher rootMatcher;
    private List<ParseError> parseErrors;
    private ValueStack<V> valueStack;
    private Object initialValueStackSnapshot;

    public AbstractParseRunner(@Nonnull Rule rule) {
        this.rootMatcher = (Matcher)Preconditions.checkNotNull((Object)((Matcher)rule), (Object)"rule");
    }

    public Matcher getRootMatcher() {
        return this.rootMatcher;
    }

    @Override
    public ParseRunner<V> withParseErrors(List<ParseError> parseErrors) {
        this.parseErrors = parseErrors;
        return this;
    }

    public List<ParseError> getParseErrors() {
        if (this.parseErrors == null) {
            this.withParseErrors(new ArrayList<ParseError>());
        }
        return this.parseErrors;
    }

    @Override
    public ParseRunner<V> withValueStack(@Nonnull ValueStack<V> valueStack) {
        this.valueStack = (ValueStack)Preconditions.checkNotNull(valueStack, (Object)"valueStack");
        this.initialValueStackSnapshot = valueStack.takeSnapshot();
        return this;
    }

    public ValueStack<V> getValueStack() {
        if (this.valueStack == null) {
            this.withValueStack(new DefaultValueStack());
        }
        return this.valueStack;
    }

    @Override
    public ParsingResult<V> run(String input) {
        return this.run((CharSequence)input);
    }

    @Override
    public ParsingResult<V> run(CharSequence input) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        return this.run(new CharSequenceInputBuffer(input));
    }

    @Override
    public ParsingResult<V> run(char[] input) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        return this.run(new DefaultInputBuffer(input));
    }

    protected void resetValueStack() {
        this.getValueStack().restoreSnapshot(this.initialValueStackSnapshot);
    }

    protected MatcherContext<V> createRootContext(InputBuffer inputBuffer, MatchHandler matchHandler, boolean fastStringMatching) {
        return new MatcherContext<V>(inputBuffer, this.getValueStack(), this.getParseErrors(), matchHandler, this.rootMatcher, fastStringMatching);
    }

    protected ParsingResult<V> createParsingResult(boolean matched, MatcherContext<V> rootContext) {
        return new ParsingResult<V>(matched, rootContext.getNode(), this.getValueStack(), this.getParseErrors(), rootContext.getInputBuffer());
    }
}

