/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.Node;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.support.LabelPrefixPredicate;
import org.parboiled.support.NodeFormatter;
import org.parboiled.support.ParsingResult;
import org.parboiled.trees.GraphUtils;

public final class ParseTreeUtils {
    private ParseTreeUtils() {
    }

    @Nullable
    public static <V> Node<V> findNodeByPath(Node<V> parent, String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.findNodeByPath(parent.getChildren(), path) : null;
    }

    @Nullable
    public static <V> Node<V> findNodeByPath(List<Node<V>> parents, String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        if (parents == null) {
            return null;
        }
        if (parents.isEmpty()) {
            return null;
        }
        int separatorIndex = path.indexOf(47);
        String prefix = separatorIndex != -1 ? path.substring(0, separatorIndex) : path;
        int start = 0;
        int step = 1;
        if (prefix.startsWith("last:")) {
            prefix = prefix.substring(5);
            start = parents.size() - 1;
            step = -1;
        }
        for (int i = start; 0 <= i && i < parents.size(); i += step) {
            Node<V> child = parents.get(i);
            if (!Strings.nullToEmpty((String)child.getLabel()).startsWith(prefix)) continue;
            return separatorIndex == -1 ? child : ParseTreeUtils.findNodeByPath(child, path.substring(separatorIndex + 1));
        }
        return null;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(Node<V> parent, String path, C collection) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull(collection, (Object)"collection");
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.collectNodesByPath(parent.getChildren(), path, collection) : collection;
    }

    @Nonnull
    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(@Nullable List<Node<V>> parents, @Nonnull String path, @Nonnull C collection) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull(collection, (Object)"collection");
        if (parents == null) {
            return collection;
        }
        if (parents.isEmpty()) {
            return collection;
        }
        int separatorIndex = path.indexOf(47);
        String prefix = separatorIndex != -1 ? path.substring(0, separatorIndex) : path;
        for (Node<V> child : parents) {
            if (!prefix.startsWith(Strings.nullToEmpty((String)child.getLabel()))) continue;
            if (separatorIndex == -1) {
                collection.add(child);
                continue;
            }
            ParseTreeUtils.collectNodesByPath(child, path.substring(separatorIndex + 1), collection);
        }
        return collection;
    }

    @Nullable
    public static <V> Node<V> findNode(@Nullable Node<V> parent, @Nonnull Predicate<Node<V>> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        if (parent == null) {
            return null;
        }
        if (predicate.apply(parent)) {
            return parent;
        }
        if (!GraphUtils.hasChildren(parent)) {
            return null;
        }
        return ParseTreeUtils.findNode(parent.getChildren(), predicate);
    }

    @Nullable
    public static <V> Node<V> findNode(@Nullable List<Node<V>> parents, @Nonnull Predicate<Node<V>> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        if (parents == null) {
            return null;
        }
        if (parents.isEmpty()) {
            return null;
        }
        for (Node<V> child : parents) {
            Node<V> found = ParseTreeUtils.findNode(child, predicate);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public static <V> Node<V> findNodeByLabel(@Nullable Node<V> parent, @Nonnull String labelPrefix) {
        return ParseTreeUtils.findNode(parent, new LabelPrefixPredicate(labelPrefix));
    }

    @Nullable
    public static <V> Node<V> findNodeByLabel(@Nullable List<Node<V>> parents, @Nonnull String labelPrefix) {
        return ParseTreeUtils.findNode(parents, new LabelPrefixPredicate(labelPrefix));
    }

    @Nullable
    public static <V> Node<V> findLastNode(@Nullable Node<V> parent, @Nonnull Predicate<Node<V>> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        if (parent == null) {
            return null;
        }
        if (predicate.apply(parent)) {
            return parent;
        }
        if (!GraphUtils.hasChildren(parent)) {
            return null;
        }
        return ParseTreeUtils.findLastNode(parent.getChildren(), predicate);
    }

    @Nullable
    public static <V> Node<V> findLastNode(@Nullable List<Node<V>> parents, @Nonnull Predicate<Node<V>> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        if (parents == null) {
            return null;
        }
        if (parents.isEmpty()) {
            return null;
        }
        int parentsSize = parents.size();
        for (int i = parentsSize - 1; i >= 0; --i) {
            Node<V> found = ParseTreeUtils.findLastNode(parents.get(i), predicate);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nonnull
    public static <V, C extends Collection<Node<V>>> C collectNodes(@Nullable Node<V> parent, @Nonnull Predicate<Node<V>> predicate, @Nonnull C collection) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        Preconditions.checkNotNull(collection, (Object)"collection");
        if (parent == null) {
            return collection;
        }
        return GraphUtils.hasChildren(parent) ? ParseTreeUtils.collectNodes(parent.getChildren(), predicate, collection) : collection;
    }

    @Nonnull
    public static String getNodeText(@Nonnull Node<?> node, @Nonnull InputBuffer inputBuffer) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkNotNull((Object)inputBuffer, (Object)"inputBuffer");
        if (!node.hasError()) {
            return inputBuffer.extract(node.getStartIndex(), node.getEndIndex());
        }
        StringBuilder sb = new StringBuilder();
        block6: for (int i = node.getStartIndex(); i < node.getEndIndex(); ++i) {
            char c = inputBuffer.charAt(i);
            switch (c) {
                case '\ufdea': {
                    ++i;
                    continue block6;
                }
                case '\ufdeb': 
                case '\uffff': {
                    continue block6;
                }
                case '\ufded': {
                    ++i;
                    while (inputBuffer.charAt(i) != '\ufdee') {
                        ++i;
                    }
                    continue block6;
                }
                case '\ufdec': 
                case '\ufdee': 
                case '\ufdef': {
                    throw new IllegalStateException();
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Nonnull
    public static <V, C extends Collection<Node<V>>> C collectNodes(@Nullable List<Node<V>> parents, @Nonnull Predicate<Node<V>> predicate, @Nonnull C collection) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        Preconditions.checkNotNull(collection, (Object)"collection");
        if (parents == null) {
            return collection;
        }
        if (parents.isEmpty()) {
            return collection;
        }
        for (Node<V> child : parents) {
            if (predicate.apply(child)) {
                collection.add(child);
            }
            ParseTreeUtils.collectNodes(child, predicate, collection);
        }
        return collection;
    }

    public static <V> String printNodeTree(ParsingResult<V> parsingResult) {
        Preconditions.checkNotNull(parsingResult, (Object)"parsingResult");
        return ParseTreeUtils.printNodeTree(parsingResult, Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    @Nonnull
    public static <V> String printNodeTree(@Nonnull ParsingResult<V> parsingResult, @Nonnull Predicate<Node<V>> nodeFilter, @Nonnull Predicate<Node<V>> subTreeFilter) {
        Preconditions.checkNotNull(parsingResult, (Object)"parsingResult");
        Preconditions.checkNotNull(nodeFilter, (Object)"nodeFilter");
        Preconditions.checkNotNull(subTreeFilter, (Object)"subTreeFilter");
        return GraphUtils.printTree(parsingResult.parseTreeRoot, new NodeFormatter(parsingResult.inputBuffer), nodeFilter, subTreeFilter);
    }
}

