/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.Node;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.ParseError;
import org.parboiled.support.ValueStack;

public class ParsingResult<V> {
    public final boolean matched;
    public final Node<V> parseTreeRoot;
    @Nullable
    public final V resultValue;
    public final ValueStack<V> valueStack;
    public final List<ParseError> parseErrors;
    public final InputBuffer inputBuffer;

    public ParsingResult(boolean matched, Node<V> parseTreeRoot, @Nonnull ValueStack<V> valueStack, @Nonnull List<ParseError> parseErrors, @Nonnull InputBuffer inputBuffer) {
        this.matched = matched;
        this.parseTreeRoot = parseTreeRoot;
        this.valueStack = (ValueStack)Preconditions.checkNotNull(valueStack);
        this.resultValue = valueStack.isEmpty() ? null : valueStack.peek();
        this.parseErrors = (List)Preconditions.checkNotNull(parseErrors);
        this.inputBuffer = (InputBuffer)Preconditions.checkNotNull((Object)inputBuffer);
    }

    public boolean hasErrors() {
        return !this.parseErrors.isEmpty();
    }
}

