/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.annotation.Nonnull;
import org.parboiled.support.Var;

public class StringBuilderVar
extends Var<StringBuilder> {
    public StringBuilderVar() {
        super(new Supplier<StringBuilder>(){

            public StringBuilder get() {
                return new StringBuilder();
            }
        });
    }

    public StringBuilderVar(StringBuilder value) {
        super(Suppliers.ofInstance((Object)value));
    }

    public boolean isEmpty() {
        return this.get().length() == 0;
    }

    public String getString() {
        return this.get().toString();
    }

    public char[] getChars() {
        StringBuilder sb = this.get();
        char[] buf = new char[sb.length()];
        sb.getChars(0, buf.length, buf, 0);
        return buf;
    }

    public boolean append(String text) {
        this.get().append(text);
        return true;
    }

    public StringBuilderVar appended(String text) {
        this.append(text);
        return this;
    }

    public boolean append(char c) {
        this.get().append(c);
        return true;
    }

    public StringBuilderVar appended(char c) {
        this.append(c);
        return this;
    }

    public boolean clearContents() {
        this.get().setLength(0);
        return true;
    }

    public StringBuilderVar contentsCleared() {
        this.get().setLength(0);
        return this;
    }

    @Override
    @Nonnull
    public StringBuilder get() {
        StringBuilder superValue = (StringBuilder)super.get();
        return superValue == null ? new StringBuilder() : superValue;
    }
}

