/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.github.parboiled1.grappa.misc.SupplierAdapter;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.Deque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.common.Factory;
import org.parboiled.common.Reference;

public class Var<T>
extends Reference<T> {
    private final Supplier<T> supplier;
    private final Deque<T> stack = Lists.newLinkedList();
    private int level;
    private String name;

    public Var() {
        this((Object)null);
    }

    public Var(@Nullable T value) {
        super(value);
        this.supplier = Suppliers.ofInstance(value);
    }

    public Var(@Nonnull Supplier<T> supplier) {
        this.supplier = (Supplier)Preconditions.checkNotNull(supplier);
    }

    @Deprecated
    public Var(@Nonnull Factory<T> factory) {
        this.supplier = new SupplierAdapter<T>(factory);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean enterFrame() {
        if (this.level++ > 0) {
            this.stack.add(this.get());
        }
        return this.set(this.supplier.get());
    }

    public boolean exitFrame() {
        if (--this.level > 0) {
            this.set(this.stack.removeLast());
        }
        return true;
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }
}

