/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.github.parboiled1.grappa.transform.asm.AsmHelper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.BaseParser;
import org.parboiled.ContextAware;
import org.parboiled.support.Var;

public final class AsmUtils {
    private static final Map<String, Class<?>> classForDesc = new HashMap();

    private AsmUtils() {
    }

    @Deprecated
    public static ClassReader createClassReader(Class<?> c) throws IOException {
        Preconditions.checkNotNull(c);
        String classFilename = c.getName().replace('.', '/') + ".class";
        InputStream inputStream = c.getClassLoader().getResourceAsStream(classFilename);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classFilename);
        }
        return new ClassReader(inputStream);
    }

    public static String getExtendedParserClassName(String parserClassName) {
        Preconditions.checkNotNull((Object)parserClassName, (Object)"parserClassName");
        return parserClassName + "$$parboiled";
    }

    public static synchronized Class<?> getClassForInternalName(String classDesc) {
        Preconditions.checkNotNull((Object)classDesc, (Object)"classDesc");
        Class<?> clazz = classForDesc.get(classDesc);
        if (clazz != null) {
            return clazz;
        }
        if (classDesc.charAt(0) == '[') {
            Class<?> compType = AsmUtils.getClassForType(Type.getType((String)classDesc.substring(1)));
            clazz = Array.newInstance(compType, 0).getClass();
        } else {
            String className = classDesc.replace('/', '.');
            try {
                clazz = AsmUtils.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException("Error loading class '" + className + "' for rule method analysis", e2);
                }
            }
        }
        classForDesc.put(classDesc, clazz);
        return clazz;
    }

    public static Class<?> getClassForType(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
            case 9: 
            case 10: {
                return AsmUtils.getClassForInternalName(type.getInternalName());
            }
        }
        throw new IllegalStateException();
    }

    public static Field getClassField(String classInternalName, String fieldName) {
        Class<?> c;
        Preconditions.checkNotNull((Object)classInternalName, (Object)"classInternalName");
        Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName");
        for (Class<?> current = c = AsmUtils.getClassForInternalName(classInternalName); current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        throw new RuntimeException("Field '" + fieldName + "' not found in '" + c.getCanonicalName() + "' or any superclass");
    }

    public static Method getClassMethod(String classInternalName, String methodName, String methodDesc) {
        Preconditions.checkNotNull((Object)classInternalName, (Object)"classInternalName");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)methodDesc, (Object)"methodDesc");
        Class<?> clazz = AsmUtils.getClassForInternalName(classInternalName);
        Type[] types = Type.getArgumentTypes((String)methodDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        Method method = AsmUtils.findMethod(clazz, methodName, argTypes);
        if (method == null) {
            throw new RuntimeException("Method '" + methodName + "' with descriptor '" + methodDesc + "' not found in '" + clazz + "' or any supertype");
        }
        return method;
    }

    private static Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method found;
        block4: {
            found = null;
            if (clazz != null) {
                try {
                    found = clazz.getDeclaredMethod(methodName, argTypes);
                }
                catch (NoSuchMethodException e) {
                    Class<?> interfaceClass;
                    found = AsmUtils.findMethod(clazz.getSuperclass(), methodName, argTypes);
                    if (found != null) break block4;
                    Class<?>[] arr$ = clazz.getInterfaces();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (found = AsmUtils.findMethod(interfaceClass = arr$[i$], methodName, argTypes)) == null; ++i$) {
                    }
                }
            }
        }
        return found;
    }

    public static Constructor<?> getClassConstructor(String classInternalName, String constructorDesc) {
        Preconditions.checkNotNull((Object)classInternalName, (Object)"classInternalName");
        Preconditions.checkNotNull((Object)constructorDesc, (Object)"constructorDesc");
        Class<?> clazz = AsmUtils.getClassForInternalName(classInternalName);
        Type[] types = Type.getArgumentTypes((String)constructorDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        try {
            return clazz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Constructor with descriptor '" + constructorDesc + "' not found in '" + clazz, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findLoadedClass(String className, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)className, (Object)"className");
        Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        Class<?> classLoaderBaseClass = Class.forName("java.lang.ClassLoader");
        Method findLoadedClassMethod = classLoaderBaseClass.getDeclaredMethod("findLoadedClass", String.class);
        findLoadedClassMethod.setAccessible(true);
        try {
            Class clazz = (Class)findLoadedClassMethod.invoke((Object)classLoader, className);
            findLoadedClassMethod.setAccessible(false);
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                findLoadedClassMethod.setAccessible(false);
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClass(String className, byte[] code, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)className, (Object)"className");
        Preconditions.checkNotNull((Object)code, (Object)"code");
        Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        Class<?> classLoaderBaseClass = Class.forName("java.lang.ClassLoader");
        Method defineClassMethod = classLoaderBaseClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineClassMethod.setAccessible(true);
        try {
            Class clazz = (Class)defineClassMethod.invoke((Object)classLoader, className, code, 0, code.length);
            defineClassMethod.setAccessible(false);
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                defineClassMethod.setAccessible(false);
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load class '" + className + '\'', e);
            }
        }
    }

    public static InsnList createArgumentLoaders(String methodDescriptor) {
        Preconditions.checkNotNull((Object)methodDescriptor, (Object)"methodDescriptor");
        InsnList instructions = new InsnList();
        Type[] types = Type.getArgumentTypes((String)methodDescriptor);
        for (int i = 0; i < types.length; ++i) {
            instructions.add((AbstractInsnNode)new VarInsnNode(AsmHelper.loadingOpcodeFor(types[i]), i + 1));
        }
        return instructions;
    }

    @Deprecated
    public static int getLoadingOpcode(Type argType) {
        Preconditions.checkNotNull((Object)argType, (Object)"argType");
        switch (argType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 21;
            }
            case 8: {
                return 24;
            }
            case 6: {
                return 23;
            }
            case 7: {
                return 22;
            }
            case 9: 
            case 10: {
                return 25;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isAssignableTo(String classInternalName, Class<?> type) {
        Preconditions.checkNotNull((Object)classInternalName, (Object)"classInternalName");
        Preconditions.checkNotNull(type, (Object)"type");
        return type.isAssignableFrom(AsmUtils.getClassForInternalName(classInternalName));
    }

    public static boolean isBooleanValueOfZ(AbstractInsnNode insn) {
        Preconditions.checkNotNull((Object)insn, (Object)"insn");
        if (insn.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isBooleanValueOfZ(mi.owner, mi.name, mi.desc);
    }

    public static boolean isBooleanValueOfZ(String methodOwner, String methodName, String methodDesc) {
        Preconditions.checkNotNull((Object)methodOwner, (Object)"methodOwner");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)methodDesc, (Object)"methodDesc");
        return "java/lang/Boolean".equals(methodOwner) && "valueOf".equals(methodName) && "(Z)Ljava/lang/Boolean;".equals(methodDesc);
    }

    public static boolean isActionRoot(AbstractInsnNode insn) {
        Preconditions.checkNotNull((Object)insn, (Object)"insn");
        if (insn.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isActionRoot(mi.owner, mi.name);
    }

    public static boolean isActionRoot(String methodOwner, String methodName) {
        Preconditions.checkNotNull((Object)methodOwner, (Object)"methodOwner");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        return "ACTION".equals(methodName) && AsmUtils.isAssignableTo(methodOwner, BaseParser.class);
    }

    public static boolean isVarRoot(AbstractInsnNode insn) {
        Preconditions.checkNotNull((Object)insn, (Object)"insn");
        if (insn.getOpcode() != 183) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isVarRoot(mi.owner, mi.name, mi.desc);
    }

    public static boolean isVarRoot(String methodOwner, String methodName, String methodDesc) {
        Preconditions.checkNotNull((Object)methodOwner, (Object)"methodOwner");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)methodDesc, (Object)"methodDesc");
        return "<init>".equals(methodName) && "(Ljava/lang/Object;)V".equals(methodDesc) && AsmUtils.isAssignableTo(methodOwner, Var.class);
    }

    public static boolean isCallOnContextAware(AbstractInsnNode insn) {
        Preconditions.checkNotNull((Object)insn, (Object)"insn");
        if (insn.getOpcode() != 182 && insn.getOpcode() != 185) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isAssignableTo(mi.owner, ContextAware.class);
    }
}

