/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.util.Printer;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGroup;

public class InstructionGraphNode
extends BasicValue {
    private AbstractInsnNode instruction;
    private final BasicValue resultValue;
    private final List<InstructionGraphNode> predecessors = new ArrayList<InstructionGraphNode>();
    private boolean isActionRoot;
    private final boolean isVarInitRoot;
    private final boolean isCallOnContextAware;
    private final boolean isXLoad;
    private final boolean isXStore;
    private InstructionGroup group;

    public InstructionGraphNode(AbstractInsnNode instruction, BasicValue resultValue) {
        super(null);
        this.instruction = instruction;
        this.resultValue = resultValue;
        this.isActionRoot = AsmUtils.isActionRoot(instruction);
        this.isVarInitRoot = AsmUtils.isVarRoot(instruction);
        this.isCallOnContextAware = AsmUtils.isCallOnContextAware(instruction);
        this.isXLoad = 21 <= instruction.getOpcode() && instruction.getOpcode() < 46;
        this.isXStore = 54 <= instruction.getOpcode() && instruction.getOpcode() < 79;
    }

    public int getSize() {
        return this.resultValue.getSize();
    }

    public AbstractInsnNode getInstruction() {
        return this.instruction;
    }

    public void setInstruction(AbstractInsnNode instruction) {
        this.instruction = instruction;
    }

    public BasicValue getResultValue() {
        return this.resultValue;
    }

    public List<InstructionGraphNode> getPredecessors() {
        return this.predecessors;
    }

    public InstructionGroup getGroup() {
        return this.group;
    }

    public void setGroup(InstructionGroup newGroup) {
        if (newGroup == this.group) {
            return;
        }
        if (this.group != null) {
            this.group.getNodes().remove((Object)this);
        }
        this.group = newGroup;
        if (this.group != null) {
            this.group.getNodes().add(this);
        }
    }

    public boolean isActionRoot() {
        return this.isActionRoot;
    }

    public void setIsActionRoot() {
        this.isActionRoot = true;
    }

    public boolean isVarInitRoot() {
        return this.isVarInitRoot;
    }

    public boolean isCallOnContextAware() {
        return this.isCallOnContextAware;
    }

    public boolean isXLoad() {
        return this.isXLoad;
    }

    public boolean isXStore() {
        return this.isXStore;
    }

    public void addPredecessors(Collection<BasicValue> preds) {
        Preconditions.checkNotNull(preds, (Object)"preds");
        for (BasicValue pred : preds) {
            if (!(pred instanceof InstructionGraphNode)) continue;
            this.addPredecessor((InstructionGraphNode)pred);
        }
    }

    public void addPredecessor(InstructionGraphNode node) {
        if (!this.predecessors.contains((Object)node)) {
            this.predecessors.add(node);
        }
    }

    public boolean equals(@Nullable Object value) {
        return value == this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public String toString() {
        return this.instruction.getOpcode() != -1 ? Printer.OPCODES[this.instruction.getOpcode()] : super.toString();
    }
}

