/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.parboiled.transform.ActionClassGenerator;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.ClassNodeInitializer;
import org.parboiled.transform.ConstructorGenerator;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.VarInitClassGenerator;
import org.parboiled.transform.process.BodyWithSuperCallReplacer;
import org.parboiled.transform.process.CachingGenerator;
import org.parboiled.transform.process.FlagMarkingGenerator;
import org.parboiled.transform.process.ImplicitActionsConverter;
import org.parboiled.transform.process.InstructionGraphCreator;
import org.parboiled.transform.process.InstructionGroupCreator;
import org.parboiled.transform.process.InstructionGroupPreparer;
import org.parboiled.transform.process.LabellingGenerator;
import org.parboiled.transform.process.ReturnInstructionUnifier;
import org.parboiled.transform.process.RuleMethodProcessor;
import org.parboiled.transform.process.RuleMethodRewriter;
import org.parboiled.transform.process.SuperCallRewriter;
import org.parboiled.transform.process.UnusedLabelsRemover;
import org.parboiled.transform.process.VarFramingGenerator;

public class ParserTransformer {
    private ParserTransformer() {
    }

    public static synchronized <T> Class<? extends T> transformParser(Class<T> parserClass) throws Exception {
        Preconditions.checkNotNull(parserClass, (Object)"parserClass");
        String name = AsmUtils.getExtendedParserClassName(parserClass.getName());
        Class<?> extendedClass = AsmUtils.findLoadedClass(name, parserClass.getClassLoader());
        Class<?> ret = extendedClass != null ? extendedClass : ParserTransformer.extendParserClass(parserClass).getExtendedClass();
        return ret;
    }

    public static byte[] getByteCode(Class<?> parserClass) throws Exception {
        ParserClassNode node = ParserTransformer.extendParserClass(parserClass);
        return node.getClassCode();
    }

    @VisibleForTesting
    static ParserClassNode extendParserClass(Class<?> parserClass) throws Exception {
        ParserClassNode classNode = new ParserClassNode(parserClass);
        new ClassNodeInitializer().process(classNode);
        ParserTransformer.runMethodTransformers(classNode);
        new ConstructorGenerator().process(classNode);
        ParserTransformer.defineExtendedParserClass(classNode);
        return classNode;
    }

    private static void runMethodTransformers(ParserClassNode classNode) throws Exception {
        List<RuleMethodProcessor> methodProcessors = ParserTransformer.createRuleMethodProcessors();
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            if (ruleMethod.hasDontExtend()) continue;
            for (RuleMethodProcessor methodProcessor : methodProcessors) {
                if (!methodProcessor.appliesTo(classNode, ruleMethod)) continue;
                methodProcessor.process(classNode, ruleMethod);
            }
        }
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            if (ruleMethod.isGenerationSkipped()) continue;
            classNode.methods.add(ruleMethod);
        }
    }

    static List<RuleMethodProcessor> createRuleMethodProcessors() {
        return ImmutableList.of((Object)new UnusedLabelsRemover(), (Object)new ReturnInstructionUnifier(), (Object)new InstructionGraphCreator(), (Object)new ImplicitActionsConverter(), (Object)new InstructionGroupCreator(), (Object)new InstructionGroupPreparer(), (Object)new ActionClassGenerator(false), (Object)new VarInitClassGenerator(false), (Object)new RuleMethodRewriter(), (Object)new SuperCallRewriter(), (Object)new BodyWithSuperCallReplacer(), (Object)new VarFramingGenerator(), (Object[])new RuleMethodProcessor[]{new LabellingGenerator(), new FlagMarkingGenerator(), new CachingGenerator()});
    }

    private static void defineExtendedParserClass(ParserClassNode node) {
        ClassWriter classWriter = new ClassWriter(1);
        node.accept((ClassVisitor)classWriter);
        node.setClassCode(classWriter.toByteArray());
        Class<?> extendedClass = AsmUtils.loadClass(node.name.replace('/', '.'), node.getClassCode(), node.getParentClass().getClassLoader());
        node.setExtendedClass(extendedClass);
    }
}

