/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.github.parboiled1.grappa.transform.asm.ClassHelper;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.transform.CacheArguments;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;
import org.parboiled.transform.process.RuleMethodProcessor;

public class CachingGenerator
implements RuleMethodProcessor {
    private ParserClassNode classNode;
    private RuleMethod method;
    private InsnList instructions;
    private AbstractInsnNode current;
    private String cacheFieldName;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return method.hasCachedAnnotation();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        Preconditions.checkState((!method.isSuperMethod() ? 1 : 0) != 0);
        this.classNode = classNode;
        this.method = method;
        this.instructions = method.instructions;
        this.current = this.instructions.getFirst();
        this.generateCacheHitReturn();
        this.generateStoreNewProxyMatcher();
        this.seekToReturnInstruction();
        this.generateArmProxyMatcher();
        this.generateStoreInCache();
    }

    private void generateCacheHitReturn() {
        this.generateGetFromCache();
        this.insert((AbstractInsnNode)new InsnNode(89));
        LabelNode cacheMissLabel = new LabelNode();
        this.insert((AbstractInsnNode)new JumpInsnNode(198, cacheMissLabel));
        this.insert((AbstractInsnNode)new InsnNode(176));
        this.insert((AbstractInsnNode)cacheMissLabel);
        this.insert((AbstractInsnNode)new InsnNode(87));
    }

    private void generateGetFromCache() {
        Type[] paramTypes = Type.getArgumentTypes((String)this.method.desc);
        this.cacheFieldName = this.findUnusedCacheFieldName();
        String cacheFieldDesc = paramTypes.length == 0 ? Types.RULE_DESC : "Ljava/util/HashMap;";
        FieldNode field = new FieldNode(2, this.cacheFieldName, cacheFieldDesc, null, null);
        FieldInsnNode insn = new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, cacheFieldDesc);
        this.classNode.fields.add(field);
        this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        this.insert((AbstractInsnNode)insn);
        if (paramTypes.length == 0) {
            return;
        }
        this.insert((AbstractInsnNode)new InsnNode(89));
        LabelNode alreadyInitialized = new LabelNode();
        this.insert((AbstractInsnNode)new JumpInsnNode(199, alreadyInitialized));
        this.insert((AbstractInsnNode)new InsnNode(87));
        this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        this.insert((AbstractInsnNode)new TypeInsnNode(187, "java/util/HashMap"));
        this.insert((AbstractInsnNode)new InsnNode(90));
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new MethodInsnNode(183, "java/util/HashMap", "<init>", "()V", false));
        this.insert((AbstractInsnNode)new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, cacheFieldDesc));
        this.insert((AbstractInsnNode)alreadyInitialized);
        if (paramTypes.length > 1 || paramTypes[0].getSort() == 9) {
            String arguments = Type.getInternalName(CacheArguments.class);
            this.insert((AbstractInsnNode)new TypeInsnNode(187, arguments));
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.generatePushNewParameterObjectArray(paramTypes);
            this.insert((AbstractInsnNode)new MethodInsnNode(183, arguments, "<init>", "([Ljava/lang/Object;)V", false));
        } else {
            this.generatePushParameterAsObject(paramTypes, 0);
        }
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new VarInsnNode(58, this.method.maxLocals));
        this.insert((AbstractInsnNode)new MethodInsnNode(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false));
        this.insert((AbstractInsnNode)new TypeInsnNode(192, Types.RULE.getInternalName()));
    }

    private String findUnusedCacheFieldName() {
        String name = "cache$" + this.method.name;
        int i = 2;
        while (this.hasField(name)) {
            name = "cache$" + this.method.name + i++;
        }
        return name;
    }

    public boolean hasField(String fieldName) {
        for (FieldNode field : this.classNode.fields) {
            if (!fieldName.equals(field.name)) continue;
            return true;
        }
        return false;
    }

    private void generatePushNewParameterObjectArray(Type[] paramTypes) {
        this.insert((AbstractInsnNode)new IntInsnNode(16, paramTypes.length));
        this.insert((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
        for (int i = 0; i < paramTypes.length; ++i) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new IntInsnNode(16, i));
            this.generatePushParameterAsObject(paramTypes, i);
            this.insert((AbstractInsnNode)new InsnNode(83));
        }
    }

    private void generatePushParameterAsObject(Type[] paramTypes, int parameterNr) {
        switch (paramTypes[parameterNr++].getSort()) {
            case 1: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false));
                return;
            }
            case 2: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false));
                return;
            }
            case 3: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false));
                return;
            }
            case 4: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false));
                return;
            }
            case 5: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false));
                return;
            }
            case 6: {
                this.insert((AbstractInsnNode)new VarInsnNode(23, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false));
                return;
            }
            case 7: {
                this.insert((AbstractInsnNode)new VarInsnNode(22, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false));
                return;
            }
            case 8: {
                this.insert((AbstractInsnNode)new VarInsnNode(24, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false));
                return;
            }
            case 9: 
            case 10: {
                this.insert((AbstractInsnNode)new VarInsnNode(25, parameterNr));
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void generateStoreNewProxyMatcher() {
        String proxyMatcherType = Types.PROXY_MATCHER.getInternalName();
        this.insert((AbstractInsnNode)new TypeInsnNode(187, proxyMatcherType));
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new MethodInsnNode(183, proxyMatcherType, "<init>", "()V", false));
        this.generateStoreInCache();
    }

    private void seekToReturnInstruction() {
        while (this.current.getOpcode() != 176) {
            this.current = this.current.getNext();
        }
    }

    private void generateArmProxyMatcher() {
        String proxyMatcherType = Types.PROXY_MATCHER.getInternalName();
        ClassHelper helper = new ClassHelper(ProxyMatcher.class);
        this.insert((AbstractInsnNode)new InsnNode(90));
        this.insert((AbstractInsnNode)new TypeInsnNode(192, Types.MATCHER.getInternalName()));
        this.insert((AbstractInsnNode)helper.voidMethodCall("arm", Matcher.class));
    }

    private void generateStoreInCache() {
        Type[] paramTypes = Type.getArgumentTypes((String)this.method.desc);
        this.insert((AbstractInsnNode)new InsnNode(89));
        if (paramTypes.length == 0) {
            this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
            this.insert((AbstractInsnNode)new InsnNode(95));
            this.insert((AbstractInsnNode)new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, Types.RULE_DESC));
            return;
        }
        this.insert((AbstractInsnNode)new VarInsnNode(25, this.method.maxLocals));
        this.insert((AbstractInsnNode)new InsnNode(95));
        this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        this.insert((AbstractInsnNode)new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, "Ljava/util/HashMap;"));
        this.insert((AbstractInsnNode)new InsnNode(91));
        this.insert((AbstractInsnNode)new InsnNode(87));
        this.insert((AbstractInsnNode)new MethodInsnNode(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false));
        this.insert((AbstractInsnNode)new InsnNode(87));
    }

    private void insert(AbstractInsnNode instruction) {
        this.instructions.insertBefore(this.current, instruction);
    }
}

