/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodInterpreter;
import org.parboiled.transform.process.RuleMethodProcessor;

public class InstructionGraphCreator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return method.containsImplicitActions() || method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        final RuleMethodInterpreter interpreter = new RuleMethodInterpreter(method);
        new Analyzer((Interpreter)interpreter){

            protected void newControlFlowEdge(int insn, int successor) {
                interpreter.newControlFlowEdge(insn, successor);
            }

            protected boolean newControlFlowExceptionEdge(int insn, int successor) {
                interpreter.newControlFlowEdge(insn, successor);
                return true;
            }
        }.analyze(classNode.name, (MethodNode)method);
        interpreter.finish();
    }
}

