/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.support.Checks;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class InstructionGroupCreator
implements RuleMethodProcessor {
    private final Map<String, Integer> memberModifiers = new HashMap<String, Integer>();
    private RuleMethod method;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        this.method = (RuleMethod)((Object)Preconditions.checkNotNull((Object)((Object)method), (Object)"method"));
        this.createGroups();
        for (InstructionGroup group : method.getGroups()) {
            this.sort(group);
            this.markUngroupedEnclosedNodes(group);
            this.verify(group);
        }
        for (InstructionGraphNode node : method.getGraphNodes()) {
            if (node.getGroup() != null) continue;
            this.verifyAccess(node);
        }
    }

    private void createGroups() {
        for (InstructionGraphNode node : this.method.getGraphNodes()) {
            if (!node.isActionRoot() && !node.isVarInitRoot()) continue;
            InstructionGroup group = new InstructionGroup(node);
            this.markGroup(node, group);
            this.method.getGroups().add(group);
        }
    }

    private void markGroup(InstructionGraphNode node, InstructionGroup group) {
        Checks.ensure(node == group.getRoot() || !node.isActionRoot() && !node.isVarInitRoot(), "Method '%s' contains illegal nesting of ACTION and/or Var initializer constructs", this.method.name);
        if (node.getGroup() != null) {
            return;
        }
        node.setGroup(group);
        if (node.isXLoad()) {
            return;
        }
        if (node.isVarInitRoot()) {
            Preconditions.checkState((node.getPredecessors().size() == 2 ? 1 : 0) != 0);
            this.markGroup(node.getPredecessors().get(1), group);
        } else {
            for (InstructionGraphNode pred : node.getPredecessors()) {
                this.markGroup(pred, group);
            }
        }
    }

    private void sort(InstructionGroup group) {
        MethodIndexComparator comparator = new MethodIndexComparator(this.method.instructions);
        Collections.sort(group.getNodes(), comparator);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void markUngroupedEnclosedNodes(InstructionGroup group) {
        block0: while (true) {
            int i = this.getIndexOfFirstInsn(group);
            int max = this.getIndexOfLastInsn(group);
            while (true) {
                if (i >= max) {
                    return;
                }
                InstructionGraphNode node = this.method.getGraphNodes().get(i);
                if (node.getGroup() == null) {
                    this.markGroup(node, group);
                    this.sort(group);
                    continue block0;
                }
                ++i;
            }
            break;
        }
    }

    private void verify(InstructionGroup group) {
        int sizeMinus1;
        List<InstructionGraphNode> nodes = group.getNodes();
        Preconditions.checkState((nodes.get(sizeMinus1 = nodes.size() - 1) == group.getRoot() ? 1 : 0) != 0);
        for (int i = 0; i < sizeMinus1; ++i) {
            InstructionGraphNode node = nodes.get(i);
            Checks.ensure(!node.isXStore(), "An ACTION or Var initializer in rule method '%s' contains illegal writes to a local variable or parameter", this.method.name);
            this.verifyAccess(node);
        }
        Checks.ensure(this.getIndexOfLastInsn(group) - this.getIndexOfFirstInsn(group) == sizeMinus1, "Error during bytecode analysis of rule method '%s': discontinuous group block", this.method.name);
    }

    private void verifyAccess(InstructionGraphNode node) {
        switch (node.getInstruction().getOpcode()) {
            case 178: 
            case 180: {
                FieldInsnNode field = (FieldInsnNode)node.getInstruction();
                Checks.ensure(!this.isPrivateField(field.owner, field.name), "Rule method '%s' contains an illegal access to private field '%s'.\nMark the field protected or package-private if you want to prevent public access!", this.method.name, field.name);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodInsnNode calledMethod = (MethodInsnNode)node.getInstruction();
                Checks.ensure(!this.isPrivate(calledMethod.owner, calledMethod.name, calledMethod.desc), "Rule method '%s' contains an illegal call to private method '%s'.\nMark '%s' protected or package-private if you want to prevent public access!", this.method.name, calledMethod.name, calledMethod.name);
            }
        }
    }

    private int getIndexOfFirstInsn(InstructionGroup group) {
        return this.method.instructions.indexOf(group.getNodes().get(0).getInstruction());
    }

    private int getIndexOfLastInsn(InstructionGroup group) {
        List<InstructionGraphNode> graphNodes = group.getNodes();
        return this.method.instructions.indexOf(graphNodes.get(graphNodes.size() - 1).getInstruction());
    }

    private boolean isPrivateField(String owner, String name) {
        String key = owner + '#' + name;
        Integer modifiers = this.memberModifiers.get(key);
        if (modifiers == null) {
            modifiers = AsmUtils.getClassField(owner, name).getModifiers();
            this.memberModifiers.put(key, modifiers);
        }
        return Modifier.isPrivate(modifiers);
    }

    private boolean isPrivate(String owner, String name, String desc) {
        return "<init>".equals(name) ? this.isPrivateInstantiation(owner, desc) : this.isPrivateMethod(owner, name, desc);
    }

    private boolean isPrivateMethod(String owner, String name, String desc) {
        String key = owner + '#' + name + '#' + desc;
        Integer modifiers = this.memberModifiers.get(key);
        if (modifiers == null) {
            modifiers = AsmUtils.getClassMethod(owner, name, desc).getModifiers();
            this.memberModifiers.put(key, modifiers);
        }
        return Modifier.isPrivate(modifiers);
    }

    private boolean isPrivateInstantiation(String owner, String desc) {
        Integer modifiers = this.memberModifiers.get(owner);
        if (modifiers == null) {
            modifiers = AsmUtils.getClassForInternalName(owner).getModifiers();
            this.memberModifiers.put(owner, modifiers);
        }
        if (Modifier.isPrivate(modifiers)) {
            return true;
        }
        String key = owner + "#<init>#" + desc;
        modifiers = this.memberModifiers.get(key);
        if (modifiers == null) {
            modifiers = AsmUtils.getClassConstructor(owner, desc).getModifiers();
            this.memberModifiers.put(key, modifiers);
        }
        return Modifier.isPrivate(modifiers);
    }

    private static final class MethodIndexComparator
    implements Comparator<InstructionGraphNode> {
        private final InsnList instructions;

        private MethodIndexComparator(@Nonnull InsnList instructions) {
            this.instructions = (InsnList)Preconditions.checkNotNull((Object)instructions);
        }

        @Override
        public int compare(InstructionGraphNode o1, InstructionGraphNode o2) {
            int i1 = this.instructions.indexOf(o1.getInstruction());
            int i2 = this.instructions.indexOf(o2.getInstruction());
            return Ints.compare((int)i1, (int)i2);
        }
    }
}

