/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;
import org.parboiled.transform.process.RuleMethodProcessor;

public class LabellingGenerator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return !method.hasDontLabelAnnotation();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        Preconditions.checkState((!method.isSuperMethod() ? 1 : 0) != 0);
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        LabelNode isNullLabel = new LabelNode();
        instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(89));
        instructions.insertBefore(ret, (AbstractInsnNode)new JumpInsnNode(198, isNullLabel));
        instructions.insertBefore(ret, (AbstractInsnNode)new LdcInsnNode((Object)this.getLabelText(method)));
        instructions.insertBefore(ret, (AbstractInsnNode)new MethodInsnNode(185, Types.RULE.getInternalName(), "label", "(Ljava/lang/String;)" + Types.RULE_DESC, true));
        instructions.insertBefore(ret, (AbstractInsnNode)isNullLabel);
    }

    public String getLabelText(RuleMethod method) {
        if (method.visibleAnnotations == null) {
            return method.name;
        }
        Iterator i$ = method.visibleAnnotations.iterator();
        while (i$.hasNext()) {
            AnnotationNode annotationObj;
            AnnotationNode annotation = annotationObj = (AnnotationNode)i$.next();
            if (!annotation.desc.equals(Types.LABEL_DESC) || annotation.values == null) continue;
            Preconditions.checkState((boolean)"value".equals(annotation.values.get(0)));
            String labelValue = (String)annotation.values.get(1);
            return labelValue.isEmpty() ? method.name : labelValue;
        }
        return method.name;
    }
}

