/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class ReturnInstructionUnifier
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        return method.getNumberOfReturns() > 1;
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        Preconditions.checkState((method.getNumberOfReturns() > 1 ? 1 : 0) != 0);
        AbstractInsnNode current = method.instructions.getLast();
        while (current.getOpcode() != 176) {
            current = current.getPrevious();
        }
        LabelNode lastReturnLabel = new LabelNode();
        method.instructions.insertBefore(current, (AbstractInsnNode)lastReturnLabel);
        while ((current = current.getPrevious()) != null) {
            if (current.getOpcode() != 176) continue;
            JumpInsnNode gotoInstruction = new JumpInsnNode(167, lastReturnLabel);
            method.instructions.set(current, (AbstractInsnNode)gotoInstruction);
            current = gotoInstruction;
        }
    }
}

