/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.github.parboiled1.grappa.transform.asm.AsmHelper;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class RuleMethodRewriter
implements RuleMethodProcessor {
    private RuleMethod method;
    private InstructionGroup instructionGroup;
    private int actionNr;
    private int varInitNr;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        this.method = (RuleMethod)((Object)Preconditions.checkNotNull((Object)((Object)method), (Object)"method"));
        this.actionNr = 0;
        this.varInitNr = 0;
        Iterator<InstructionGroup> i$ = method.getGroups().iterator();
        while (i$.hasNext()) {
            InstructionGroup group;
            this.instructionGroup = group = i$.next();
            this.createNewGroupClassInstance();
            this.initializeFields();
            InstructionGraphNode root = group.getRoot();
            if (root.isActionRoot()) {
                this.removeGroupRootInstruction();
                continue;
            }
            ((MethodInsnNode)root.getInstruction()).desc = "(Lorg/parboiled/common/Factory;)V";
        }
        method.setBodyRewritten();
    }

    private void createNewGroupClassInstance() {
        String internalName = this.instructionGroup.getGroupClassType().getInternalName();
        InstructionGraphNode root = this.instructionGroup.getRoot();
        this.insert((AbstractInsnNode)new TypeInsnNode(187, internalName));
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new LdcInsnNode((Object)(this.method.name + (root.isActionRoot() ? "_Action" + ++this.actionNr : "_VarInit" + ++this.varInitNr))));
        this.insert((AbstractInsnNode)new MethodInsnNode(183, internalName, "<init>", "(Ljava/lang/String;)V", false));
        if (root.isActionRoot() && this.method.hasSkipActionsInPredicatesAnnotation()) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new MethodInsnNode(182, internalName, "setSkipInPredicates", "()V", false));
        }
    }

    private void initializeFields() {
        String internalName = this.instructionGroup.getGroupClassType().getInternalName();
        for (FieldNode field : this.instructionGroup.getFields()) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new VarInsnNode(AsmHelper.loadingOpcodeFor((Type)field.value), field.access));
            this.insert((AbstractInsnNode)new FieldInsnNode(181, internalName, field.name, field.desc));
        }
    }

    private void insert(AbstractInsnNode insn) {
        this.method.instructions.insertBefore(this.instructionGroup.getRoot().getInstruction(), insn);
    }

    private void removeGroupRootInstruction() {
        this.method.instructions.remove(this.instructionGroup.getRoot().getInstruction());
    }
}

