/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class SuperCallRewriter
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return method.containsPotentialSuperCalls();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        InsnList instructions = method.instructions;
        AbstractInsnNode insn = instructions.getFirst();
        while (insn.getOpcode() != 176) {
            if (insn.getOpcode() == 183) {
                this.process(classNode, method, (MethodInsnNode)insn);
            }
            insn = insn.getNext();
        }
    }

    private void process(ParserClassNode classNode, RuleMethod method, MethodInsnNode insn) {
        if ("<init>".equals(insn.name)) {
            return;
        }
        String superMethodName = SuperCallRewriter.getSuperMethodName(method, insn);
        RuleMethod superMethod = classNode.getRuleMethods().get(superMethodName + insn.desc);
        if (superMethod == null) {
            return;
        }
        if (!superMethod.isBodyRewritten()) {
            return;
        }
        superMethod.dontSkipGeneration();
        insn.setOpcode(182);
        insn.name = superMethodName;
        insn.owner = classNode.name;
        method.setBodyRewritten();
    }

    private static String getSuperMethodName(RuleMethod method, MethodInsnNode insn) {
        Class<?> clazz = method.getOwnerClass();
        String superMethodName = method.name;
        do {
            Preconditions.checkState(((clazz = clazz.getSuperclass()) != null ? 1 : 0) != 0);
            superMethodName = '$' + superMethodName;
        } while (!Type.getInternalName(clazz).equals(insn.owner));
        return superMethodName;
    }
}

