/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.util;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import com.knuddels.jtokkit.api.ModelType;
import com.plexpt.chatgpt.entity.chat.Message;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class TokensUtil {
    public static EncodingRegistry registry = Encodings.newDefaultEncodingRegistry();
    public static Encoding encoding = registry.getEncoding(EncodingType.CL100K_BASE);
    public static Encoding encoding4o = registry.getEncoding(EncodingType.O200K_BASE);

    public static int countTextTokens(String text) {
        return encoding4o.countTokens(text);
    }

    public static int countTextTokens(String text, String model) {
        if (StringUtils.startsWithIgnoreCase((String)model, (String)ModelType.GPT_3_5_TURBO.getName())) {
            return encoding.countTokens(text);
        }
        return encoding4o.countTokens(text);
    }

    public static ModelType getModelTypeByName(String name) {
        Optional optional = ModelType.fromName((String)name);
        return optional.orElse(ModelType.GPT_3_5_TURBO);
    }

    public static int tokens(List<Message> messages, String model) {
        if (CollectionUtils.isEmpty(messages)) {
            return 0;
        }
        Encoding encodingUsed = encoding;
        int tokensPerMessage = 4;
        int tokensPerName = -1;
        if (StringUtils.startsWithIgnoreCase((String)model, (String)ModelType.GPT_4.getName())) {
            tokensPerMessage = 3;
            tokensPerName = 1;
        }
        if (StringUtils.startsWithIgnoreCase((String)model, (String)ModelType.GPT_4O.getName())) {
            encodingUsed = encoding4o;
        }
        int sum = 0;
        for (Message message : messages) {
            sum += tokensPerMessage;
            sum += encodingUsed.countTokens(message.getContent());
            sum += encodingUsed.countTokens(message.getRole());
            if (StringUtils.isEmpty((Object)message.getName())) continue;
            sum += encodingUsed.countTokens(message.getName());
            sum += tokensPerName;
        }
        return sum += 3;
    }

    public static int tokens(String modelName, List<Message> messages) {
        return TokensUtil.tokens(messages, modelName);
    }

    @Generated
    private TokensUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

