/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ForbidAnnotationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "annotation.incorrect.target";
    private Set<String> annotationNames = new HashSet<String>();
    private int[] annotationTargets = new int[0];

    public void setAnnotationNames(String[] names) {
        if (names != null) {
            for (String name : names) {
                this.annotationNames.add(name);
            }
        }
    }

    public void setAnnotationTargets(String[] targets) {
        if (targets != null) {
            this.annotationTargets = new int[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                this.annotationTargets[i] = TokenUtils.getTokenId((String)targets[i]);
            }
            Arrays.sort(this.annotationTargets);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST annotation) {
        String annotationName = ForbidAnnotationCheck.getAnnotationName(annotation);
        DetailAST annotationTarget = annotation.getParent().getParent();
        int targetType = annotationTarget.getType();
        if (this.isRequiredAnnotationName(annotationName) && this.isForbiddenAnnotationTarget(targetType)) {
            String currentTarget = annotationTarget.getText();
            this.log(annotation.getLineNo(), MSG_KEY, new Object[]{currentTarget, annotationName});
        }
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST directname = annotation.findFirstToken(58);
        String result = directname != null ? directname.getText() : annotation.findFirstToken(59).getLastChild().getText();
        return result;
    }

    private boolean isRequiredAnnotationName(String annotationName) {
        return this.annotationNames.contains(annotationName);
    }

    private boolean isForbiddenAnnotationTarget(int targetType) {
        return Arrays.binarySearch(this.annotationTargets, targetType) > -1;
    }
}

