/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CustomDeclarationOrderCheck
extends AbstractCheck {
    public static final String MSG_KEY_FIELD = "custom.declaration.order.field";
    public static final String MSG_KEY_METHOD = "custom.declaration.order.method";
    public static final String MSG_KEY_CONSTRUCTOR = "custom.declaration.order.constructor";
    public static final String MSG_KEY_CLASS = "custom.declaration.order.class";
    public static final String MSG_KEY_INTERFACE = "custom.declaration.order.interface";
    public static final String MSG_KEY_ENUM = "custom.declaration.order.enum";
    public static final String MSG_KEY_INVALID_SETTER = "custom.declaration.order.invalid.setter";
    private static final String INNER_ENUM_MACRO = "InnerEnum";
    private static final String INNER_INTERFACE_MACRO = "InnerInterface";
    private static final String INNER_CLASS_MACRO = "InnerClass";
    private static final String CTOR_MACRO = "Ctor";
    private static final String METHOD_MACRO = "Method";
    private static final String ANNON_CLASS_FIELD_MACRO = "DeclareAnnonClassField";
    private static final String FIELD_MACRO = "Field";
    private static final String GETTER_SETTER_MACRO = "GetterSetter";
    private static final String MAIN_METHOD_MACRO = "MainMethod";
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final String DEFAULT_DECLARATION = "Field(.*public .*) ### Field(.*protected .*) ### Field(.*private .*) ### CTOR(.*) ### MainMethod(.*) ### GetterSetter(.*) ### Method(.*) ### InnerClass(.*) ### InnerInterface(.*) ### InnerEnum(.*)";
    private static final Comparator<DetailAST> AST_LINE_COMPARATOR = new Comparator<DetailAST>(){

        @Override
        public int compare(DetailAST aObj1, DetailAST aObj2) {
            return aObj1.getLineNo() - aObj2.getLineNo();
        }
    };
    private final List<FormatMatcher> customOrderDeclaration = new ArrayList<FormatMatcher>();
    private int compileFlags;
    private boolean checkInnerClasses;
    private boolean checkGettersSetters;
    private String fieldPrefix = "";
    private final Deque<ClassDetail> classDetails = new LinkedList<ClassDetail>();

    public CustomDeclarationOrderCheck() {
        this.setCustomDeclarationOrder(DEFAULT_DECLARATION);
    }

    public final void setCustomDeclarationOrder(String inputOrderDeclaration) {
        this.customOrderDeclaration.clear();
        for (String currentState : inputOrderDeclaration.split("\\s*###\\s*")) {
            try {
                this.customOrderDeclaration.add(this.parseInputDeclarationRule(currentState));
            }
            catch (StringIndexOutOfBoundsException exp) {
                throw new IllegalArgumentException("Unable to parse input rule: " + currentState, exp);
            }
        }
    }

    public void setFieldPrefix(String fieldPrefix) {
        this.fieldPrefix = fieldPrefix;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.compileFlags = caseSensitive ? 0 : 2;
        for (FormatMatcher currentRule : this.customOrderDeclaration) {
            currentRule.setCompileFlags(this.compileFlags);
        }
    }

    public int[] getDefaultTokens() {
        int size = this.customOrderDeclaration.size();
        int[] tokenTypes = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            FormatMatcher currentRule = this.customOrderDeclaration.get(i);
            tokenTypes[i] = currentRule.getClassMember();
            if (currentRule.hasRule(INNER_CLASS_MACRO)) {
                this.checkInnerClasses = true;
                continue;
            }
            if (!currentRule.hasRule(GETTER_SETTER_MACRO)) continue;
            this.checkGettersSetters = true;
        }
        tokenTypes[size] = 14;
        return tokenTypes;
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: {
                int position;
                if (CustomDeclarationOrderCheck.isClassDefInMethodDef(ast)) break;
                if (this.checkInnerClasses && !this.classDetails.isEmpty() && (position = this.getPositionInOrderDeclaration(ast)) != -1) {
                    if (this.isWrongPosition(position)) {
                        this.logWrongOrderedElement(ast, position);
                    } else {
                        this.classDetails.peek().setCurrentPosition(position);
                    }
                }
                this.classDetails.push(new ClassDetail());
                break;
            }
            default: {
                int position;
                DetailAST classDefAst;
                DetailAST objBlockAst = ast.getParent();
                if (objBlockAst == null || objBlockAst.getType() != 6 || (classDefAst = objBlockAst.getParent()).getType() != 14 || CustomDeclarationOrderCheck.isClassDefInMethodDef(classDefAst)) break;
                if (this.checkGettersSetters) {
                    this.collectGetterSetter(ast);
                }
                if ((position = this.getPositionInOrderDeclaration(ast)) == -1) break;
                if (this.isWrongPosition(position)) {
                    this.logWrongOrderedElement(ast, position);
                    break;
                }
                this.classDetails.peek().setCurrentPosition(position);
            }
        }
    }

    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 && !CustomDeclarationOrderCheck.isClassDefInMethodDef(ast)) {
            ClassDetail classDetail = this.classDetails.pop();
            if (this.checkGettersSetters) {
                Map<DetailAST, DetailAST> gettersSetters = classDetail.getWrongOrderedGettersSetters();
                this.logWrongOrderedSetters(gettersSetters);
            }
        }
    }

    private FormatMatcher parseInputDeclarationRule(String currentState) {
        String macro = currentState.substring(0, currentState.indexOf(40)).trim();
        int classMember = CustomDeclarationOrderCheck.convertMacroToTokenType(macro);
        if (classMember == -1) {
            throw new IllegalArgumentException("Unable to parse " + macro);
        }
        String regExp = currentState.substring(currentState.indexOf(40) + 1, currentState.lastIndexOf(41));
        if (regExp.isEmpty()) {
            regExp = "package";
        }
        FormatMatcher matcher = new FormatMatcher(currentState, classMember);
        matcher.updateRegexp(regExp, this.compileFlags);
        return matcher;
    }

    private static int convertMacroToTokenType(String inputMemberName) {
        int result = -1;
        if (FIELD_MACRO.equalsIgnoreCase(inputMemberName) || ANNON_CLASS_FIELD_MACRO.equalsIgnoreCase(inputMemberName)) {
            result = 10;
        } else if (GETTER_SETTER_MACRO.equalsIgnoreCase(inputMemberName) || METHOD_MACRO.equalsIgnoreCase(inputMemberName) || MAIN_METHOD_MACRO.equalsIgnoreCase(inputMemberName)) {
            result = 9;
        } else if (CTOR_MACRO.equalsIgnoreCase(inputMemberName)) {
            result = 8;
        } else if (INNER_CLASS_MACRO.equalsIgnoreCase(inputMemberName)) {
            result = 14;
        } else if (INNER_INTERFACE_MACRO.equalsIgnoreCase(inputMemberName)) {
            result = 15;
        } else if (INNER_ENUM_MACRO.equalsIgnoreCase(inputMemberName)) {
            result = 154;
        }
        return result;
    }

    private static boolean isClassDefInMethodDef(DetailAST classDef) {
        boolean result = false;
        for (DetailAST currentParentAst = classDef.getParent(); currentParentAst != null; currentParentAst = currentParentAst.getParent()) {
            if (currentParentAst.getType() != 9) continue;
            result = true;
            break;
        }
        return result;
    }

    private void logWrongOrderedElement(DetailAST ast, int position) {
        String token = null;
        switch (ast.getType()) {
            case 10: {
                token = MSG_KEY_FIELD;
                break;
            }
            case 9: {
                token = MSG_KEY_METHOD;
                break;
            }
            case 8: {
                token = MSG_KEY_CONSTRUCTOR;
                break;
            }
            case 14: {
                token = MSG_KEY_CLASS;
                break;
            }
            case 15: {
                token = MSG_KEY_INTERFACE;
                break;
            }
            case 154: {
                token = MSG_KEY_ENUM;
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
        int expectedPosition = this.classDetails.peek().getCurrentPosition();
        this.log(ast, token, new Object[]{this.customOrderDeclaration.get(position).getRule(), this.customOrderDeclaration.get(expectedPosition).getRule()});
    }

    private boolean isWrongPosition(int position) {
        boolean result = false;
        ClassDetail classDetail = this.classDetails.peek();
        Integer classCurrentPosition = classDetail.getCurrentPosition();
        if (classCurrentPosition > position) {
            result = true;
        }
        return result;
    }

    private void logWrongOrderedSetters(Map<DetailAST, DetailAST> gettersSetters) {
        for (Map.Entry<DetailAST, DetailAST> entry : gettersSetters.entrySet()) {
            DetailAST setterAst = entry.getKey();
            DetailAST getterAst = entry.getValue();
            this.log(setterAst.getLineNo(), MSG_KEY_INVALID_SETTER, new Object[]{CustomDeclarationOrderCheck.getIdentifier(setterAst), CustomDeclarationOrderCheck.getIdentifier(getterAst)});
        }
    }

    private void collectGetterSetter(DetailAST methodDefAst) {
        if (methodDefAst.getType() == 9) {
            String methodName = CustomDeclarationOrderCheck.getIdentifier(methodDefAst);
            if (CustomDeclarationOrderCheck.isGetterName(methodName)) {
                if (this.isGetterCorrect(methodDefAst, GETTER_PREFIX)) {
                    this.classDetails.peek().addGetter(methodDefAst);
                }
            } else if (CustomDeclarationOrderCheck.isBooleanGetterName(methodName)) {
                if (this.isGetterCorrect(methodDefAst, BOOLEAN_GETTER_PREFIX)) {
                    this.classDetails.peek().addGetter(methodDefAst);
                }
            } else if (CustomDeclarationOrderCheck.isSetterName(methodName) && this.isSetterCorrect(methodDefAst, SETTER_PREFIX)) {
                this.classDetails.peek().addSetter(methodDefAst);
            }
        }
    }

    private int getPositionInOrderDeclaration(DetailAST ast) {
        int result = -1;
        String modifiers = CustomDeclarationOrderCheck.getCombinedModifiersList(ast);
        for (int index = 0; result != 1 && index < this.customOrderDeclaration.size(); ++index) {
            FormatMatcher currentRule = this.customOrderDeclaration.get(index);
            if (currentRule.getClassMember() != ast.getType() || !currentRule.getRegexp().matcher(modifiers).find()) continue;
            if (currentRule.hasRule(ANNON_CLASS_FIELD_MACRO) || currentRule.hasRule(GETTER_SETTER_MACRO) || currentRule.hasRule(MAIN_METHOD_MACRO)) {
                String methodName = CustomDeclarationOrderCheck.getIdentifier(ast);
                ClassDetail classDetail = this.classDetails.peek();
                if (!CustomDeclarationOrderCheck.isAnonymousClassField(ast) && !classDetail.containsGetter(methodName) && !classDetail.containsSetter(methodName) && !CustomDeclarationOrderCheck.isMainMethod(ast)) continue;
                result = index;
                continue;
            }
            if (result != -1) continue;
            result = index;
        }
        return result;
    }

    private static boolean isAnonymousClassField(DetailAST varDefinitionAst) {
        DetailAST assignAst;
        boolean result = false;
        int parentType = varDefinitionAst.getParent().getParent().getType();
        if (parentType == 14 && (assignAst = varDefinitionAst.findFirstToken(80)) != null) {
            DetailAST expressionToAssignAst = assignAst.findFirstToken(28);
            result = expressionToAssignAst != null && CustomDeclarationOrderCheck.isAnonymousClass(expressionToAssignAst);
        }
        return result;
    }

    private static boolean isGetterName(String methodName) {
        return methodName.startsWith(GETTER_PREFIX);
    }

    private static boolean isBooleanGetterName(String methodName) {
        return methodName.startsWith(BOOLEAN_GETTER_PREFIX);
    }

    private static boolean isSetterName(String methodName) {
        return methodName.startsWith(SETTER_PREFIX);
    }

    private boolean isGetterCorrect(DetailAST methodDef, String methodPrefix) {
        DetailAST returnStatementAst;
        DetailAST statementsAst;
        boolean result = false;
        DetailAST parameters = methodDef.findFirstToken(20);
        if (parameters.getChildCount() == 0 && (statementsAst = methodDef.findFirstToken(7)) != null && (returnStatementAst = statementsAst.findFirstToken(88)) != null) {
            DetailAST exprAst = returnStatementAst.getFirstChild();
            String returnedFieldName = CustomDeclarationOrderCheck.getNameOfGetterField(exprAst);
            String methodName = CustomDeclarationOrderCheck.getIdentifier(methodDef);
            String methodNameWithoutPrefix = CustomDeclarationOrderCheck.getNameWithoutPrefix(methodName, methodPrefix);
            if (returnedFieldName != null && !CustomDeclarationOrderCheck.localVariableHidesField(statementsAst, returnedFieldName) && this.verifyFieldAndMethodName(returnedFieldName, methodNameWithoutPrefix)) {
                result = true;
            }
        }
        return result;
    }

    private static boolean localVariableHidesField(DetailAST slist, String fieldName) {
        boolean result = false;
        for (DetailAST currNode = slist.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (currNode.getType() != 10 || !fieldName.equals(CustomDeclarationOrderCheck.getIdentifier(currNode))) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isSetterCorrect(DetailAST methodDefAst, String methodPrefix) {
        boolean result = false;
        DetailAST methodTypeAst = methodDefAst.findFirstToken(13);
        if (methodTypeAst.branchContains(49)) {
            DetailAST statementsAst = methodDefAst.findFirstToken(7);
            String methodName = CustomDeclarationOrderCheck.getIdentifier(methodDefAst);
            String setterFieldName = this.fieldPrefix + CustomDeclarationOrderCheck.getNameWithoutPrefix(methodName, methodPrefix);
            result = statementsAst != null && !CustomDeclarationOrderCheck.localVariableHidesField(statementsAst, setterFieldName) && CustomDeclarationOrderCheck.isFieldUpdate(statementsAst, setterFieldName);
        }
        return result;
    }

    private static boolean isAnonymousClass(DetailAST expressionAst) {
        boolean result = false;
        DetailAST literalNewAst = expressionAst.findFirstToken(136);
        if (literalNewAst != null) {
            DetailAST objBlockAst = literalNewAst.findFirstToken(6);
            result = objBlockAst != null;
        }
        return result;
    }

    private static String getCombinedModifiersList(DetailAST ast) {
        StringBuilder modifiers = new StringBuilder();
        DetailAST astNode = ast.findFirstToken(5);
        if (astNode.getFirstChild() == null) {
            modifiers.append("package ");
        }
        while (astNode.getType() != 58) {
            if (astNode != null && astNode.getFirstChild() != null) {
                modifiers.append(CustomDeclarationOrderCheck.getModifiersAsText(astNode.getFirstChild()));
                modifiers.append(" ");
            }
            astNode = astNode.getNextSibling();
        }
        modifiers.append(astNode.getText());
        return modifiers.toString();
    }

    private static String getModifiersAsText(DetailAST ast) {
        DetailAST astNode = ast;
        String separator = "";
        StringBuffer modifiers = new StringBuffer();
        if (astNode.getParent().getType() == 5) {
            separator = " ";
        }
        while (astNode != null) {
            if (astNode.getFirstChild() != null) {
                modifiers.append(CustomDeclarationOrderCheck.getModifiersAsText(astNode.getFirstChild()));
            } else {
                if (astNode.getType() == 48) {
                    modifiers.append("[");
                }
                modifiers.append(astNode.getText());
            }
            modifiers.append(separator);
            astNode = astNode.getNextSibling();
        }
        return modifiers.toString().trim();
    }

    private static String getNameWithoutPrefix(String name, String prefix) {
        String result = null;
        if (name.startsWith(prefix)) {
            result = name.substring(prefix.length());
            result = Introspector.decapitalize(result);
        }
        return result;
    }

    private static String getIdentifier(DetailAST ast) {
        String result = null;
        DetailAST ident = ast.findFirstToken(58);
        if (ident != null) {
            result = ident.getText();
        }
        return result;
    }

    private static boolean isFieldUpdate(DetailAST statementsAst, String fieldName) {
        boolean result = false;
        DetailAST currentStatement = statementsAst.getFirstChild();
        while (currentStatement != null && currentStatement != statementsAst) {
            String nameOfSetterField = null;
            if (currentStatement.getType() == 80) {
                nameOfSetterField = CustomDeclarationOrderCheck.getNameOfAssignedField(currentStatement);
            } else if (currentStatement.getType() == 27) {
                nameOfSetterField = CustomDeclarationOrderCheck.getNameOfSuperClassUpdatedField(currentStatement);
            }
            if (fieldName.equalsIgnoreCase(nameOfSetterField)) {
                result = true;
                break;
            }
            DetailAST nextStatement = currentStatement.getFirstChild();
            while (currentStatement != null && nextStatement == null) {
                nextStatement = currentStatement.getNextSibling();
                if (nextStatement != null) continue;
                currentStatement = currentStatement.getParent();
            }
            currentStatement = nextStatement;
        }
        return result;
    }

    private static String getNameOfAssignedField(DetailAST assignAst) {
        DetailAST methodCallDot;
        String nameOfSettingField = null;
        if (assignAst.getChildCount() > 0 && (assignAst.getLastChild().getType() == 58 || assignAst.getLastChild().getType() == 27) && (methodCallDot = assignAst.getFirstChild()).getChildCount() == 2 && "this".equals(methodCallDot.getFirstChild().getText())) {
            nameOfSettingField = methodCallDot.getLastChild().getText();
        }
        return nameOfSettingField;
    }

    private static String getNameOfSuperClassUpdatedField(DetailAST methodCallAst) {
        String nameOfSettingField = null;
        DetailAST methodCallDot = methodCallAst.getFirstChild();
        if (methodCallDot.getChildCount() == 2 && "super".equals(methodCallDot.getFirstChild().getText())) {
            nameOfSettingField = CustomDeclarationOrderCheck.getFieldName(methodCallDot);
        }
        return nameOfSettingField;
    }

    private static String getFieldName(DetailAST methodCallDotAst) {
        String nameOfSettingField = null;
        DetailAST parameterOfSetterMethod = methodCallDotAst.getNextSibling().getFirstChild();
        if (parameterOfSetterMethod != null) {
            nameOfSettingField = parameterOfSetterMethod.getFirstChild().getText();
        }
        return nameOfSettingField;
    }

    private boolean verifyFieldAndMethodName(String fieldName, String methodName) {
        return (this.fieldPrefix + methodName).equalsIgnoreCase(fieldName);
    }

    private static String getNameOfGetterField(DetailAST expr) {
        String nameOfGetterField = null;
        if (expr.getChildCount() == 1) {
            DetailAST exprFirstChild = expr.getFirstChild();
            if (exprFirstChild.getType() == 58) {
                nameOfGetterField = exprFirstChild.getText();
            } else if (exprFirstChild.getType() == 59 && exprFirstChild.getChildCount() == 2 && exprFirstChild.getFirstChild().getType() == 78 && exprFirstChild.getLastChild().getType() == 58) {
                nameOfGetterField = exprFirstChild.getLastChild().getText();
            }
        }
        return nameOfGetterField;
    }

    private static boolean isMainMethod(DetailAST methodAST) {
        boolean result = true;
        String methodName = CustomDeclarationOrderCheck.getIdentifier(methodAST);
        result = "main".equals(methodName) ? CustomDeclarationOrderCheck.isVoidType(methodAST) && CustomDeclarationOrderCheck.isMainMethodModifiers(methodAST) && CustomDeclarationOrderCheck.isMainMethodParameters(methodAST) : false;
        return result;
    }

    private static boolean isMainMethodModifiers(DetailAST methodAST) {
        boolean result = false;
        if (CustomDeclarationOrderCheck.hasChildToken(methodAST, 5)) {
            DetailAST modifiers = methodAST.findFirstToken(5);
            result = CustomDeclarationOrderCheck.hasChildToken(modifiers, 62) && CustomDeclarationOrderCheck.hasChildToken(modifiers, 64);
        }
        return result;
    }

    private static boolean isVoidType(DetailAST methodAST) {
        boolean result = true;
        if (CustomDeclarationOrderCheck.hasChildToken(methodAST, 13)) {
            DetailAST methodTypeAST = methodAST.findFirstToken(13);
            result = CustomDeclarationOrderCheck.hasChildToken(methodTypeAST, 49);
        }
        return result;
    }

    private static boolean isMainMethodParameters(DetailAST methodAST) {
        DetailAST params = methodAST.findFirstToken(20);
        return CustomDeclarationOrderCheck.hasOnlyStringArrayParameter(params) || CustomDeclarationOrderCheck.hasOnlyStringEllipsisParameter(params);
    }

    private static boolean hasOnlyStringArrayParameter(DetailAST parametersAST) {
        boolean result = true;
        if (parametersAST.getChildCount(21) == 1) {
            DetailAST parameterDefinitionAST = parametersAST.findFirstToken(21);
            DetailAST parameterTypeAST = parameterDefinitionAST.findFirstToken(13);
            if (CustomDeclarationOrderCheck.hasChildToken(parameterTypeAST, 17)) {
                DetailAST arrayDeclaratorAST = parameterTypeAST.findFirstToken(17);
                String parameterName = CustomDeclarationOrderCheck.getIdentifier(arrayDeclaratorAST);
                result = "String".equals(parameterName);
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static boolean hasOnlyStringEllipsisParameter(DetailAST parametersAST) {
        boolean result = true;
        if (parametersAST.getChildCount(21) == 1) {
            DetailAST parameterDefinitionAST = parametersAST.findFirstToken(21);
            if (CustomDeclarationOrderCheck.hasChildToken(parameterDefinitionAST, 171)) {
                DetailAST parameterTypeAST = parameterDefinitionAST.findFirstToken(13);
                String parameterName = CustomDeclarationOrderCheck.getIdentifier(parameterTypeAST);
                result = "String".equals(parameterName);
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static boolean hasChildToken(DetailAST ast, int tokenType) {
        return ast.findFirstToken(tokenType) != null;
    }

    private static class ClassDetail {
        private int currentPosition;
        private final List<DetailAST> getters = new LinkedList<DetailAST>();
        private final List<DetailAST> setters = new LinkedList<DetailAST>();

        private ClassDetail() {
        }

        public int getCurrentPosition() {
            return this.currentPosition;
        }

        public void setCurrentPosition(int position) {
            this.currentPosition = position;
        }

        public void addGetter(DetailAST getterAst) {
            this.getters.add(getterAst);
        }

        public void addSetter(DetailAST setterAst) {
            this.setters.add(setterAst);
        }

        public Map<DetailAST, DetailAST> getWrongOrderedGettersSetters() {
            LinkedHashMap<DetailAST, DetailAST> result = new LinkedHashMap<DetailAST, DetailAST>();
            if (!this.getters.isEmpty() && !this.setters.isEmpty()) {
                ArrayList<DetailAST> allGettersSetters = new ArrayList<DetailAST>(this.getters);
                allGettersSetters.addAll(this.setters);
                Collections.sort(allGettersSetters, AST_LINE_COMPARATOR);
                for (int i = 0; i < allGettersSetters.size(); ++i) {
                    result.putAll(ClassDetail.getWrongOrderedGettersSetters(allGettersSetters, i));
                }
            }
            return result;
        }

        private static Map<DetailAST, DetailAST> getWrongOrderedGettersSetters(List<DetailAST> allGettersSetters, int index) {
            DetailAST getterAst = allGettersSetters.get(index);
            String getterName = CustomDeclarationOrderCheck.getIdentifier(getterAst);
            String getterField = null;
            if (CustomDeclarationOrderCheck.isGetterName(getterName)) {
                getterField = CustomDeclarationOrderCheck.getNameWithoutPrefix(CustomDeclarationOrderCheck.getIdentifier(getterAst), CustomDeclarationOrderCheck.GETTER_PREFIX);
            } else if (CustomDeclarationOrderCheck.isBooleanGetterName(getterName)) {
                getterField = CustomDeclarationOrderCheck.getNameWithoutPrefix(CustomDeclarationOrderCheck.getIdentifier(getterAst), CustomDeclarationOrderCheck.BOOLEAN_GETTER_PREFIX);
            }
            LinkedHashMap<DetailAST, DetailAST> result = new LinkedHashMap<DetailAST, DetailAST>();
            if (getterField != null) {
                for (int j = 0; j < allGettersSetters.size(); ++j) {
                    DetailAST setterAst;
                    String setterName;
                    if (index == j || !CustomDeclarationOrderCheck.isSetterName(setterName = CustomDeclarationOrderCheck.getIdentifier(setterAst = allGettersSetters.get(j)))) continue;
                    String setterField = CustomDeclarationOrderCheck.getNameWithoutPrefix(CustomDeclarationOrderCheck.getIdentifier(setterAst), CustomDeclarationOrderCheck.SETTER_PREFIX);
                    if (j == index + 1 || !getterField.equals(setterField)) continue;
                    result.put(setterAst, getterAst);
                    break;
                }
            }
            return result;
        }

        private boolean containsGetter(String methodName) {
            boolean result = false;
            for (DetailAST methodAst : this.getters) {
                String name = CustomDeclarationOrderCheck.getIdentifier(methodAst);
                if (!name.equals(methodName)) continue;
                result = true;
            }
            return result;
        }

        private boolean containsSetter(String methodName) {
            boolean result = false;
            for (DetailAST methodAst : this.setters) {
                String name = CustomDeclarationOrderCheck.getIdentifier(methodAst);
                if (!name.equals(methodName)) continue;
                result = true;
            }
            return result;
        }
    }

    private static final class FormatMatcher {
        private Pattern regExp;
        private final int classMember;
        private final String rule;
        private String format;

        private FormatMatcher(String inputRule, int classMember) {
            this.classMember = classMember;
            this.rule = inputRule;
        }

        public Pattern getRegexp() {
            return this.regExp;
        }

        public String getRule() {
            return this.rule;
        }

        public int getClassMember() {
            return this.classMember;
        }

        public void setCompileFlags(int compileFlags) {
            this.updateRegexp(this.format, compileFlags);
        }

        private void updateRegexp(String newFormat, int compileFlags) {
            try {
                this.regExp = Pattern.compile(newFormat, compileFlags);
                this.format = newFormat;
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("unable to parse " + newFormat, ex);
            }
        }

        public boolean hasRule(String ruleCheck) {
            return this.rule.indexOf(ruleCheck) > -1;
        }

        public String toString() {
            return this.rule;
        }
    }
}

