/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ForbidInstantiationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "forbid.instantiation";
    private static final String PATH_SEPARATOR = ".";
    private Set<String> forbiddenClasses = new HashSet<String>();
    private List<String> importsList = new LinkedList<String>();

    public ForbidInstantiationCheck() {
        this.forbiddenClasses.add("java.lang.NullPointerException");
    }

    public void setForbiddenClasses(String[] classNames) {
        this.forbiddenClasses.clear();
        if (classNames != null) {
            for (String name : classNames) {
                this.forbiddenClasses.add(name);
            }
        }
    }

    public void beginTree(DetailAST rootAST) {
        this.importsList.clear();
    }

    public int[] getDefaultTokens() {
        return new int[]{30, 136};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 30: {
                this.importsList.add(ForbidInstantiationCheck.getText(ast));
                break;
            }
            case 136: {
                String instanceClass = ForbidInstantiationCheck.getText(ast);
                if (instanceClass == null) break;
                String instanceClassName = ForbidInstantiationCheck.getClassName(instanceClass);
                for (String forbiddenClass : this.forbiddenClasses) {
                    if (forbiddenClass.startsWith("java.lang.") && forbiddenClass.endsWith(instanceClassName)) {
                        this.log(ast, MSG_KEY, new Object[]{instanceClassName});
                        continue;
                    }
                    if (instanceClass.contains(PATH_SEPARATOR)) {
                        if (!instanceClass.equals(forbiddenClass)) continue;
                        this.log(ast, MSG_KEY, new Object[]{instanceClassName});
                        continue;
                    }
                    if (!this.addedUsingForbiddenImport(instanceClass, forbiddenClass)) continue;
                    this.log(ast, MSG_KEY, new Object[]{instanceClass});
                }
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private boolean addedUsingForbiddenImport(String className, String forbiddenClassNameAndPath) {
        boolean result = false;
        for (String importText : this.importsList) {
            if (!ForbidInstantiationCheck.isWildcardForbiddenImported(importText, forbiddenClassNameAndPath, className) && !ForbidInstantiationCheck.isForbiddenImported(importText, forbiddenClassNameAndPath, className)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isWildcardForbiddenImported(String importText, String forbiddenClassNameAndPath, String className) {
        String importTextWithoutAsterisk = importText.substring(0, importText.length() - 1);
        return importText.endsWith("*") && (importTextWithoutAsterisk + className).equals(forbiddenClassNameAndPath);
    }

    private static boolean isForbiddenImported(String importText, String forbiddenClassNameAndPath, String className) {
        return importText.equals(forbiddenClassNameAndPath) && importText.endsWith(className);
    }

    private static String getClassName(String classNameAndPath) {
        return classNameAndPath.replaceAll(".+\\.", "");
    }

    private static String getText(DetailAST ast) {
        String result = null;
        DetailAST textWithoutDots = ast.findFirstToken(58);
        if (textWithoutDots == null) {
            DetailAST parentDotAST = ast.findFirstToken(59);
            if (parentDotAST != null) {
                FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
                DetailAST nameAST = parentDotAST.getLastChild();
                result = dottedPathIdent.getText() + PATH_SEPARATOR + nameAST.getText();
            }
        } else {
            result = textWithoutDots.getText();
        }
        return result;
    }
}

