/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ReturnCountExtendedCheck
extends AbstractCheck {
    public static final String MSG_KEY_METHOD = "return.count.extended.method";
    public static final String MSG_KEY_CTOR = "return.count.extended.ctor";
    public static final String MSG_KEY_LAMBDA = "return.count.extended.lambda";
    private static final int DEFAULT_MAX_RETURN_COUNT = 1;
    private static final int DEFAULT_IGNORE_METHOD_LINES_COUNT = 20;
    private static final int DEFAULT_MIN_IGNORE_RETURN_DEPTH = 4;
    private static final int DEFAULT_TOP_LINES_TO_IGNORE_COUNT = 5;
    private Set<String> ignoreMethodsNames = new HashSet<String>();
    private int maxReturnCount = 1;
    private int ignoreMethodLinesCount = 20;
    private int minIgnoreReturnDepth = 4;
    private boolean ignoreEmptyReturns = true;
    private int topLinesToIgnoreCount = 5;

    public ReturnCountExtendedCheck() {
        this.ignoreMethodsNames.add("equals");
    }

    public void setIgnoreMethodsNames(String[] ignoreMethodNames) {
        this.ignoreMethodsNames.clear();
        if (ignoreMethodNames != null) {
            for (String name : ignoreMethodNames) {
                this.ignoreMethodsNames.add(name);
            }
        }
    }

    public void setMaxReturnCount(int maxReturnCount) {
        this.maxReturnCount = maxReturnCount;
    }

    public void setIgnoreMethodLinesCount(int ignoreMethodLinesCount) {
        this.ignoreMethodLinesCount = ignoreMethodLinesCount;
    }

    public void setMinIgnoreReturnDepth(int minIgnoreReturnDepth) {
        this.minIgnoreReturnDepth = minIgnoreReturnDepth;
    }

    public void setIgnoreEmptyReturns(boolean ignoreEmptyReturns) {
        this.ignoreEmptyReturns = ignoreEmptyReturns;
    }

    public void setTopLinesToIgnoreCount(int topLinesToIgnoreCount) {
        this.topLinesToIgnoreCount = topLinesToIgnoreCount;
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 8, 181};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST node) {
        DetailAST openingBrace = node.findFirstToken(7);
        String nodeName = ReturnCountExtendedCheck.getMethodName(node);
        if (openingBrace != null && !ReturnCountExtendedCheck.matches(nodeName, this.ignoreMethodsNames)) {
            int mCurReturnCount;
            DetailAST closingBrace = openingBrace.getLastChild();
            int curMethodLinesCount = ReturnCountExtendedCheck.getLinesCount(openingBrace, closingBrace);
            if (curMethodLinesCount != 0) {
                --curMethodLinesCount;
            }
            if (curMethodLinesCount >= this.ignoreMethodLinesCount && (mCurReturnCount = this.getReturnCount(node, openingBrace)) > this.maxReturnCount) {
                this.logViolation(node, nodeName, mCurReturnCount);
            }
        }
    }

    private void logViolation(DetailAST node, String nodeName, int mCurReturnCount) {
        if (node.getType() == 181) {
            this.log(node, MSG_KEY_LAMBDA, new Object[]{mCurReturnCount, this.maxReturnCount});
        } else {
            DetailAST nodeNameToken = node.findFirstToken(58);
            String mKey = node.getType() == 9 ? MSG_KEY_METHOD : MSG_KEY_CTOR;
            this.log(nodeNameToken, mKey, new Object[]{nodeName, mCurReturnCount, this.maxReturnCount});
        }
    }

    private int getReturnCount(DetailAST methodDefNode, DetailAST methodOpeningBrace) {
        int result = 0;
        DetailAST curNode = methodOpeningBrace;
        while (curNode.getType() != 73 || curNode.getParent() != methodOpeningBrace) {
            if (curNode.getType() == 88 && ReturnCountExtendedCheck.getDepth(methodDefNode, curNode) < this.minIgnoreReturnDepth && this.shouldEmptyReturnStatementBeCounted(curNode) && ReturnCountExtendedCheck.getLinesCount(methodOpeningBrace, curNode) > this.topLinesToIgnoreCount) {
                ++result;
            }
            DetailAST nextNode = curNode.getFirstChild();
            int type = curNode.getType();
            if (type == 9 || type == 14 || type == 181) {
                nextNode = curNode.getNextSibling();
            }
            while (nextNode == null) {
                nextNode = curNode.getNextSibling();
                if (nextNode != null) continue;
                curNode = curNode.getParent();
            }
            curNode = nextNode;
        }
        return result;
    }

    private boolean shouldEmptyReturnStatementBeCounted(DetailAST returnNode) {
        DetailAST returnChildNode = returnNode.getFirstChild();
        return !this.ignoreEmptyReturns || returnChildNode.getType() != 45;
    }

    private static int getDepth(DetailAST methodDefNode, DetailAST returnStmtNode) {
        int result = 0;
        DetailAST curNode = returnStmtNode;
        while (!curNode.equals((AST)methodDefNode)) {
            int type = (curNode = curNode.getParent()).getType();
            if (type != 83 && type != 89 && type != 91 && type != 85 && type != 84 && type != 95) continue;
            ++result;
        }
        return result;
    }

    private static String getMethodName(DetailAST methodDefNode) {
        String result = null;
        DetailAST ident = methodDefNode.findFirstToken(58);
        if (ident != null && methodDefNode.getType() != 181) {
            result = ident.getText();
        }
        return result;
    }

    private static int getLinesCount(DetailAST beginAst, DetailAST endAST) {
        return endAST.getLineNo() - beginAst.getLineNo();
    }

    private static boolean matches(String string, Collection<String> patterns) {
        String match = string;
        if (match == null) {
            match = "null";
        }
        boolean result = false;
        if (!patterns.isEmpty()) {
            for (String pattern : patterns) {
                if (!match.matches(pattern)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

