/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.rules.ExternalResource;

public class TextFromStandardInputStream
extends ExternalResource {
    private final SystemInMock systemInMock = new SystemInMock();
    private InputStream originalIn;

    public static TextFromStandardInputStream emptyStandardInputStream() {
        return new TextFromStandardInputStream("");
    }

    @Deprecated
    public TextFromStandardInputStream(String text) {
        this.provideText(text);
    }

    public void provideText(String ... texts) {
        this.systemInMock.provideText(Arrays.asList(texts));
    }

    public void provideLines(String ... lines) {
        String[] texts = this.appendEndOfLineToLines(lines);
        this.provideText(texts);
    }

    public void throwExceptionOnInputEnd(IOException exception) {
        this.systemInMock.throwExceptionOnInputEnd(exception);
    }

    public void throwExceptionOnInputEnd(RuntimeException exception) {
        this.systemInMock.throwExceptionOnInputEnd(exception);
    }

    private String[] appendEndOfLineToLines(String[] lines) {
        String[] texts = new String[lines.length];
        for (int index = 0; index < lines.length; ++index) {
            texts[index] = lines[index] + System.getProperty("line.separator");
        }
        return texts;
    }

    protected void before() throws Throwable {
        this.originalIn = System.in;
        System.setIn(this.systemInMock);
    }

    protected void after() {
        System.setIn(this.originalIn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SystemInMock
    extends InputStream {
        private Iterator<String> texts;
        private StringReader currentReader;
        private IOException ioException;
        private RuntimeException runtimeException;

        private SystemInMock() {
        }

        void provideText(List<String> texts) {
            this.texts = texts.iterator();
            this.updateReader();
        }

        void throwExceptionOnInputEnd(IOException exception) {
            if (this.runtimeException != null) {
                throw new IllegalStateException("You cannot call throwExceptionOnInputEnd(IOException) because throwExceptionOnInputEnd(RuntimeException) has already been called.");
            }
            this.ioException = exception;
        }

        void throwExceptionOnInputEnd(RuntimeException exception) {
            if (this.ioException != null) {
                throw new IllegalStateException("You cannot call throwExceptionOnInputEnd(RuntimeException) because throwExceptionOnInputEnd(IOException) has already been called.");
            }
            this.runtimeException = exception;
        }

        @Override
        public int read() throws IOException {
            int character = this.currentReader.read();
            if (character == -1) {
                this.handleEmptyReader();
            }
            return character;
        }

        private void handleEmptyReader() throws IOException {
            if (this.texts.hasNext()) {
                this.updateReader();
            } else {
                if (this.ioException != null) {
                    throw this.ioException;
                }
                if (this.runtimeException != null) {
                    throw this.runtimeException;
                }
            }
        }

        private void updateReader() {
            if (this.texts.hasNext()) {
                this.currentReader = new StringReader(this.texts.next());
            }
        }
    }
}

