/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system.internal;

import java.io.PrintStream;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrintStreamHandler {
    SYSTEM_OUT{

        PrintStream getStream() {
            return System.out;
        }

        void replaceCurrentStreamWithStream(PrintStream stream) {
            System.setOut(stream);
        }
    }
    ,
    SYSTEM_ERR{

        PrintStream getStream() {
            return System.err;
        }

        void replaceCurrentStreamWithStream(PrintStream stream) {
            System.setErr(stream);
        }
    };


    Statement createRestoreStatement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                PrintStream originalStream = PrintStreamHandler.this.getStream();
                try {
                    base.evaluate();
                }
                finally {
                    PrintStreamHandler.this.replaceCurrentStreamWithStream(originalStream);
                }
            }
        };
    }

    abstract PrintStream getStream();

    abstract void replaceCurrentStreamWithStream(PrintStream var1);
}

