/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.contrib.java.lang.system.internal.PrintStreamHandler;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class PrintStreamRule
implements TestRule {
    private final PrintStreamHandler printStreamHandler;
    private final MuteableLogStream muteableLogStream;

    public PrintStreamRule(PrintStreamHandler printStreamHandler) {
        this.printStreamHandler = printStreamHandler;
        try {
            this.muteableLogStream = new MuteableLogStream(printStreamHandler.getStream());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    PrintStreamRule.this.printStreamHandler.createRestoreStatement(new Statement(){

                        public void evaluate() throws Throwable {
                            PrintStreamRule.this.printStreamHandler.replaceCurrentStreamWithStream(PrintStreamRule.this.muteableLogStream);
                            base.evaluate();
                        }
                    }).evaluate();
                }
                catch (Throwable e) {
                    IOUtils.write((String)PrintStreamRule.this.muteableLogStream.getFailureLog(), (OutputStream)PrintStreamRule.this.printStreamHandler.getStream());
                    throw e;
                }
            }
        };
    }

    public void clearLog() {
        this.muteableLogStream.clearLog();
    }

    public void enableLog() {
        this.muteableLogStream.enableLog();
    }

    public String getLog() {
        return this.muteableLogStream.getLog();
    }

    public String getLogWithNormalizedLineSeparator() {
        String lineSeparator = System.getProperty("line.separator");
        return this.getLog().replace(lineSeparator, "\n");
    }

    public void mute() {
        this.muteableLogStream.mute();
    }

    public void muteForSuccessfulTests() {
        this.mute();
        this.muteableLogStream.enableFailureLog();
    }

    private static class MutableOutputStream
    extends OutputStream {
        private final OutputStream originalStream;
        private boolean mute = false;

        MutableOutputStream(OutputStream originalStream) {
            this.originalStream = originalStream;
        }

        void mute() {
            this.mute = true;
        }

        void turnOutputOn() {
            this.mute = false;
        }

        public void write(int b) throws IOException {
            if (!this.mute) {
                this.originalStream.write(b);
            }
        }
    }

    private static class MuteableLogStream
    extends PrintStream {
        private final ByteArrayOutputStream failureLog;
        private final ByteArrayOutputStream log;
        private final MutableOutputStream muteableOriginalStream;
        private final MutableOutputStream muteableFailureLog;
        private final MutableOutputStream muteableLog;

        MuteableLogStream(OutputStream out) throws UnsupportedEncodingException {
            this(out, new ByteArrayOutputStream(), new ByteArrayOutputStream());
        }

        MuteableLogStream(OutputStream out, ByteArrayOutputStream failureLog, ByteArrayOutputStream log) throws UnsupportedEncodingException {
            this(new MutableOutputStream(out), failureLog, new MutableOutputStream(failureLog), log, new MutableOutputStream(log));
        }

        MuteableLogStream(MutableOutputStream muteableOriginalStream, ByteArrayOutputStream failureLog, MutableOutputStream muteableFailureLog, ByteArrayOutputStream log, MutableOutputStream muteableLog) throws UnsupportedEncodingException {
            super((OutputStream)new TeeOutputStream((OutputStream)muteableOriginalStream, (OutputStream)new TeeOutputStream((OutputStream)muteableFailureLog, (OutputStream)muteableLog)));
            this.failureLog = failureLog;
            this.log = log;
            this.muteableOriginalStream = muteableOriginalStream;
            this.muteableFailureLog = muteableFailureLog;
            this.muteableFailureLog.mute();
            this.muteableLog = muteableLog;
            this.muteableLog.mute();
        }

        void mute() {
            this.muteableOriginalStream.mute();
        }

        void clearLog() {
            this.log.reset();
        }

        void enableLog() {
            this.muteableLog.turnOutputOn();
        }

        String getLog() {
            return this.getLog(this.log);
        }

        void enableFailureLog() {
            this.muteableFailureLog.turnOutputOn();
        }

        String getFailureLog() {
            return this.getLog(this.failureLog);
        }

        String getLog(ByteArrayOutputStream os) {
            String encoding = System.getProperty("file.encoding");
            try {
                return os.toString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

