/*
 * Decompiled with CFR 0.152.
 */
package jscover.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.Main;
import jscover.filesystem.ConfigurationForFS;
import jscover.instrument.InstrumenterService;
import jscover.util.IoService;
import jscover.util.IoUtils;
import jscover.util.LoggerUtils;

public class FileSystemInstrumenter {
    private static final Logger logger = Logger.getLogger(FileSystemInstrumenter.class.getName());
    private IoService ioService;
    private InstrumenterService instrumenterService = new InstrumenterService();
    private IoUtils ioUtils = IoUtils.getInstance();
    private LoggerUtils loggerUtils = LoggerUtils.getInstance();
    private ConfigurationForFS configuration;

    public void run(ConfigurationForFS configuration) {
        this.configuration = configuration;
        this.ioService = new IoService(configuration.isLocalStorage());
        this.loggerUtils.configureLogger(configuration.getLogLevel(), configuration.getDestDir());
        logger.log(Level.INFO, "Starting JSCover {0} file instrumentation", configuration.getVersion());
        this.ioService.generateJSCoverFilesForFileSystem(configuration.getDestDir(), configuration.getVersion());
        this.copyFolder(configuration.getSrcDir(), configuration.getDestDir());
        this.copyFolder(configuration.getSrcDir(), new File(configuration.getDestDir(), Main.reportSrcSubDir), this.getJavaScriptFilter(), true);
    }

    FilenameFilter getJavaScriptFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return file.isDirectory() || name.endsWith(".js");
            }
        };
    }

    void copyFolder(File src, File dest) {
        FilenameFilter acceptAll = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        };
        this.copyFolder(src, dest, acceptAll, false);
    }

    void copyFolder(File src, File dest, FilenameFilter filter, boolean isReportSrc) {
        String path = this.ioUtils.getRelativePath(src, this.configuration.getSrcDir());
        if (this.configuration.exclude(path)) {
            return;
        }
        if (src.isDirectory()) {
            for (String file : src.list(filter)) {
                this.copyFolder(new File(src, file), new File(dest, file), filter, isReportSrc);
            }
        } else if (!isReportSrc && src.toString().endsWith(".js") && !this.configuration.skipInstrumentation(path)) {
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdirs();
            }
            this.instrumenterService.instrumentJSForFileSystem(this.configuration, src, dest, path);
        } else if (!isReportSrc || !this.configuration.skipInstrumentation(path)) {
            this.ioUtils.copy(src, dest);
        }
    }
}

