/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.instrument.NodeProcessor;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

class ParseTreeInstrumenter
implements NodeVisitor {
    private static Logger logger = Logger.getLogger(ParseTreeInstrumenter.class.getName());
    private String fileName;
    private NodeProcessor nodeProcessor;

    public ParseTreeInstrumenter(String uri, boolean includeFunctionCoverage) {
        this.fileName = uri;
        this.nodeProcessor = new NodeProcessor(uri, includeFunctionCoverage);
    }

    public SortedSet<Integer> getValidLines() {
        return this.nodeProcessor.getValidLines();
    }

    public int getNumFunctions() {
        return this.nodeProcessor.getNumFunctions();
    }

    public boolean visit(AstNode node) {
        try {
            return this.nodeProcessor.processNode(node);
        }
        catch (RuntimeException t) {
            logger.log(Level.SEVERE, String.format("Error on line %s of %s", node.getLineno(), this.fileName), t);
            return true;
        }
    }
}

