/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jscover.Configuration;
import jscover.report.ReportFormat;
import jscover.util.IoUtils;

public class ConfigurationForReport
extends Configuration {
    public static final String HELP_PREFIX1 = "-h";
    public static final String HELP_PREFIX2 = "--help";
    public static final String FORMAT_PREFIX = "--format=";
    public static final String MERGE_PREFIX = "--merge";
    private ReportFormat reportFormat;
    private File jsonDirectory;
    private File sourceDirectory;
    private boolean showHelp;
    private boolean invalid;
    private boolean format;
    private boolean merge;
    private File mergeDestDir;
    private List<File> mergeDirs = new ArrayList<File>();
    private IoUtils ioUtils = IoUtils.getInstance();

    public void setReportFormat(ReportFormat reportFormat) {
        this.reportFormat = reportFormat;
    }

    public void setJsonDirectory(File jsonDirectory) {
        this.jsonDirectory = jsonDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public File getJsonDirectory() {
        return this.jsonDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public Boolean showHelp() {
        return this.showHelp;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isFormat() {
        return this.format;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public File getMergeDestDir() {
        return this.mergeDestDir;
    }

    public List<File> getMergeDirs() {
        return this.mergeDirs;
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }

    public ConfigurationForReport parse(String[] args) {
        if (this.parseArgs(args)) {
            return this;
        }
        if (this.format && this.merge || !this.format && !this.merge) {
            this.invalid = true;
            this.showHelp = true;
            return this;
        }
        if (this.merge ? this.parseForMerge() : this.parseForFormat(args)) {
            return this;
        }
        return this;
    }

    private boolean parseForFormat(String[] args) {
        if (this.reportFormat == ReportFormat.LCOV || this.reportFormat == ReportFormat.COBERTURAXML) {
            if (args.length != 3) {
                this.invalid = true;
                this.showHelp = true;
                return true;
            }
            this.jsonDirectory = this.getDirectory(args[args.length - 2]);
            this.sourceDirectory = this.getDirectory(args[args.length - 1]);
        } else {
            if (args.length != 2) {
                this.invalid = true;
                this.showHelp = true;
                return true;
            }
            this.jsonDirectory = this.getDirectory(args[args.length - 1]);
        }
        return false;
    }

    private boolean parseForMerge() {
        if (this.mergeDirs.size() < 3) {
            System.err.println("Must specify more than one directory to merge");
            this.invalid = true;
            this.showHelp = true;
            return true;
        }
        this.mergeDestDir = this.mergeDirs.get(this.mergeDirs.size() - 1);
        this.mergeDirs.remove(this.mergeDestDir);
        for (File mergeDir : this.mergeDirs) {
            if (this.isValidReportDirectory(mergeDir)) continue;
            this.invalid = true;
            this.showHelp = true;
            return true;
        }
        return false;
    }

    private boolean parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals(HELP_PREFIX1) || arg.equals(HELP_PREFIX2)) {
                this.showHelp = true;
                return true;
            }
            if (arg.startsWith(FORMAT_PREFIX)) {
                this.format = true;
                this.reportFormat = ReportFormat.valueOf(arg.substring(FORMAT_PREFIX.length()));
                continue;
            }
            if (arg.startsWith(MERGE_PREFIX)) {
                this.merge = true;
                continue;
            }
            if (!this.merge) continue;
            this.mergeDirs.add(new File(arg));
        }
        return false;
    }

    boolean isValidReportDirectory(File dir) {
        File jsonFile = new File(dir, "jscoverage.json");
        return this.isValidDirectory(dir) && this.isValidFile(jsonFile);
    }

    boolean isValidFile(File file) {
        if (!file.exists()) {
            System.err.println("Directory doesn't exist: " + file.getAbsolutePath());
            return false;
        }
        if (!file.isFile()) {
            System.err.println(file.getAbsolutePath() + " is not a file");
            return false;
        }
        return true;
    }

    private boolean isValidDirectory(File dir) {
        if (!dir.exists()) {
            System.err.println("Directory doesn't exist: " + dir.getAbsolutePath());
            return false;
        }
        if (!dir.isDirectory()) {
            System.err.println(dir.getAbsolutePath() + " is not a directory");
            return false;
        }
        return true;
    }

    private File getDirectory(String arg) {
        File dir = new File(arg);
        if (!dir.exists()) {
            System.err.println("Couldn't find dir " + arg);
            this.invalid = true;
            this.showHelp = true;
        }
        if (dir.isFile()) {
            System.err.println(arg + " is a file. It should be a dir.");
            this.invalid = true;
            this.showHelp = true;
        }
        return dir;
    }
}

