/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.report.FileData;
import jscover.report.JSONDataMerger;
import jscover.report.ScriptCoverageCount;
import jscover.util.IoUtils;
import jscover.util.UriFileTranslator;

public class JSONDataSaver {
    private static final Logger logger = Logger.getLogger(JSONDataSaver.class.getName());
    protected static final Set<File> files = new HashSet<File>();
    private JSONDataMerger jsonDataMerger = new JSONDataMerger();
    private IoUtils ioUtils = IoUtils.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJSONData(File reportDir, String data, List<ScriptCoverageCount> unloadJSData, UriFileTranslator uriFileTranslator) {
        try {
            this.lockOnReportDir(reportDir);
            reportDir.mkdirs();
            File jsonFile = new File(reportDir, "jscoverage.json");
            SortedMap<String, FileData> dataMap = new TreeMap<String, FileData>();
            if (jsonFile.exists()) {
                logger.info("Saving/merging JSON with existing JSON");
                String existingJSON = this.ioUtils.toString(jsonFile);
                if (uriFileTranslator.mutates()) {
                    this.translateUris(data, uriFileTranslator, dataMap);
                    dataMap = this.jsonDataMerger.mergeJSONCoverageMaps(dataMap, this.jsonDataMerger.jsonToMap(existingJSON));
                } else {
                    dataMap.putAll(this.jsonDataMerger.mergeJSONCoverageStrings(existingJSON, data));
                }
                this.ioUtils.copy(this.jsonDataMerger.toJSON(dataMap), jsonFile);
            } else if (unloadJSData != null) {
                logger.info("Saving/merging JSON with unloaded JavaScript JSON");
                dataMap.putAll(this.jsonDataMerger.createEmptyJSON(unloadJSData));
                if (uriFileTranslator.mutates()) {
                    this.translateUris(data, uriFileTranslator, dataMap);
                } else {
                    dataMap.putAll(this.jsonDataMerger.jsonToMap(data));
                }
                this.ioUtils.copy(this.jsonDataMerger.toJSON(dataMap), jsonFile);
            } else {
                logger.info("Saving JSON");
                if (uriFileTranslator.mutates()) {
                    this.translateUris(data, uriFileTranslator, dataMap);
                    this.ioUtils.copy(this.jsonDataMerger.toJSON(dataMap), jsonFile);
                } else {
                    this.ioUtils.copy(data, jsonFile);
                }
            }
        }
        finally {
            this.unlockOnReportDir(reportDir);
        }
    }

    private void translateUris(String data, UriFileTranslator uriFileTranslator, SortedMap<String, FileData> map) {
        SortedMap<String, FileData> coverageData = this.jsonDataMerger.jsonToMap(data);
        for (String uri : coverageData.keySet()) {
            map.put(uriFileTranslator.convertUriToFile(uri), (FileData)coverageData.get(uri));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockOnReportDir(File reportDir) {
        Set<File> set = files;
        synchronized (set) {
            while (files.contains(reportDir)) {
                try {
                    files.wait();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, Thread.currentThread().getName() + " INTERRUPTED", ex);
                }
            }
            files.add(reportDir);
            files.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockOnReportDir(File reportDir) {
        Set<File> set = files;
        synchronized (set) {
            files.remove(reportDir);
            files.notifyAll();
        }
    }
}

