/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jscover.ConfigurationCommon;
import jscover.util.UriFileTranslator;
import jscover.util.UriFileTranslatorNoOp;
import jscover.util.UriFileTranslatorReg;

public class ConfigurationForServer
extends ConfigurationCommon {
    public static final String DOC_ROOT_PREFIX = "--document-root=";
    public static final String PORT_PREFIX = "--port=";
    public static final String PROXY_PREFIX = "--proxy";
    public static final String SAVE_JSON_ONLY = "--save-json-only";
    public static final String REPORT_DIR_PREFIX = "--report-dir=";
    public static final String INCLUDE_UNLOADED_JS_PREFIX = "--include-unloaded-js";
    public static final String URI_TO_FILE_MATCHER_PREFIX = "--uri-to-file-matcher=";
    public static final String URI_TO_FILE_REPLACE_PREFIX = "--uri-to-file-replace=";
    private File documentRoot = new File(System.getProperty("user.dir"));
    private Integer port = 8080;
    private boolean proxy;
    private boolean saveJSONOnly;
    private File reportDir = new File(System.getProperty("user.dir"));
    private boolean includeUnloadedJS;
    private Pattern uriToFileMatcher;
    private String uriToFileReplace;
    private UriFileTranslator uriFileTranslator = new UriFileTranslatorNoOp();

    public void setDocumentRoot(File documentRoot) {
        this.documentRoot = documentRoot;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    public void setIncludeUnloadedJS(boolean includeUnloadedJS) {
        this.includeUnloadedJS = includeUnloadedJS;
    }

    public File getDocumentRoot() {
        return this.documentRoot;
    }

    public Integer getPort() {
        return this.port;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public boolean isSaveJSONOnly() {
        return this.saveJSONOnly;
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isIncludeUnloadedJS() {
        return this.includeUnloadedJS;
    }

    public Pattern getUriToFileMatcher() {
        return this.uriToFileMatcher;
    }

    public String getUriToFileReplace() {
        return this.uriToFileReplace;
    }

    public UriFileTranslator getUriFileTranslator() {
        return this.uriFileTranslator;
    }

    public void parse(String arg) {
        if (super.parseArg(arg)) {
            return;
        }
        if (!arg.startsWith("-ws")) {
            if (arg.startsWith(DOC_ROOT_PREFIX)) {
                this.documentRoot = new File(arg.substring(DOC_ROOT_PREFIX.length()));
                if (!this.documentRoot.exists()) {
                    this.setInvalid(String.format("Document root '%s' doesn't exist", this.documentRoot));
                } else if (!this.documentRoot.isDirectory()) {
                    this.setInvalid(String.format("Document root '%s' can't be a file", this.documentRoot));
                }
            } else if (arg.startsWith(PORT_PREFIX)) {
                this.port = Integer.valueOf(arg.substring(PORT_PREFIX.length()));
            } else if (arg.equals(PROXY_PREFIX)) {
                this.proxy = true;
            } else if (arg.equals(SAVE_JSON_ONLY)) {
                this.saveJSONOnly = true;
            } else if (arg.equals(INCLUDE_UNLOADED_JS_PREFIX)) {
                this.includeUnloadedJS = true;
            } else if (arg.startsWith(REPORT_DIR_PREFIX)) {
                this.reportDir = new File(arg.substring(REPORT_DIR_PREFIX.length()));
                this.reportDir.mkdirs();
            } else if (arg.startsWith(URI_TO_FILE_MATCHER_PREFIX)) {
                String patternString = arg.substring(URI_TO_FILE_MATCHER_PREFIX.length());
                try {
                    this.uriToFileMatcher = Pattern.compile(patternString);
                }
                catch (PatternSyntaxException e) {
                    this.setInvalid(String.format("Invalid pattern '%s'", patternString));
                    e.printStackTrace(System.err);
                }
            } else if (arg.startsWith(URI_TO_FILE_REPLACE_PREFIX)) {
                this.uriToFileReplace = arg.substring(URI_TO_FILE_REPLACE_PREFIX.length());
            } else {
                String message = String.format("JSCover: Extra command line argument '%s'", arg);
                if (arg.startsWith("-")) {
                    message = String.format("JSCover: Unknown option '%s'", arg);
                }
                this.setInvalid(message);
            }
        }
    }

    public static ConfigurationForServer parse(String[] args) {
        ConfigurationForServer configuration = new ConfigurationForServer();
        for (String arg : args) {
            configuration.parse(arg);
        }
        if (configuration.uriToFileMatcher != null && configuration.uriToFileReplace == null) {
            configuration.setInvalid("--uri-to-file-matcher= found without --uri-to-file-replace=");
        }
        if (configuration.uriToFileMatcher == null && configuration.uriToFileReplace != null) {
            configuration.setInvalid("--uri-to-file-replace= found without --uri-to-file-matcher=");
        }
        if (configuration.uriToFileMatcher != null) {
            configuration.uriFileTranslator = new UriFileTranslatorReg(configuration.uriToFileMatcher, configuration.uriToFileReplace);
        }
        configuration.compilerEnvirons.setLanguageVersion(configuration.JSVersion);
        return configuration;
    }
}

