/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.Main;
import jscover.instrument.InstrumenterService;
import jscover.instrument.UnloadedSourceProcessor;
import jscover.report.JSONDataSaver;
import jscover.report.ScriptCoverageCount;
import jscover.server.ConfigurationForServer;
import jscover.server.HTTP_STATUS;
import jscover.server.HttpRequest;
import jscover.server.HttpServer;
import jscover.server.MIME;
import jscover.server.ProxyService;
import jscover.server.UriNotFound;
import jscover.util.IoService;
import jscover.util.UriFileTranslator;

public class InstrumentingRequestHandler
extends HttpServer {
    private static final Logger logger = Logger.getLogger(InstrumentingRequestHandler.class.getName());
    public static final String JSCOVERAGE_STORE = "/jscoverage-store";
    static Map<String, String> uris = new HashMap<String, String>();
    private ConfigurationForServer configuration;
    private IoService ioService;
    private JSONDataSaver jsonDataSaver = new JSONDataSaver();
    private InstrumenterService instrumenterService = new InstrumenterService();
    private ProxyService proxyService = new ProxyService();
    private UnloadedSourceProcessor unloadedSourceProcessor;
    private UriFileTranslator uriFileTranslator;

    public InstrumentingRequestHandler(Socket socket, ConfigurationForServer configuration) {
        super(socket, configuration.getDocumentRoot(), configuration.getVersion());
        this.configuration = configuration;
        this.unloadedSourceProcessor = new UnloadedSourceProcessor(configuration);
        this.uriFileTranslator = configuration.getUriFileTranslator();
        this.ioService = new IoService(configuration.isLocalStorage());
    }

    @Override
    protected void handlePostOrPut(HttpRequest request) {
        String uri = request.getPath();
        if (uri.startsWith(JSCOVERAGE_STORE)) {
            this.storeReport(request, uri);
        } else if (this.configuration.isProxy()) {
            this.proxyService.handleProxyPostOrPut(request);
        } else {
            super.handlePostOrPut(request);
        }
    }

    private void storeReport(HttpRequest request, String uri) {
        logger.fine("Storing report");
        File reportDir = this.configuration.getReportDir();
        if (uri.length() > JSCOVERAGE_STORE.length()) {
            reportDir = new File(reportDir, uri.substring(JSCOVERAGE_STORE.length()));
        }
        try {
            List<ScriptCoverageCount> unloadJSData = null;
            if (this.configuration.isIncludeUnloadedJS()) {
                logger.fine("Searching for unloaded JavaScript");
                unloadJSData = this.unloadedSourceProcessor.getEmptyCoverageData(uris.keySet());
                if (!this.configuration.isSaveJSONOnly()) {
                    for (ScriptCoverageCount scriptLinesAndSource : unloadJSData) {
                        File src = new File(this.configuration.getDocumentRoot(), scriptLinesAndSource.getUri());
                        this.ioUtils.copy(src, new File(reportDir, Main.reportSrcSubDir + scriptLinesAndSource.getUri()));
                    }
                }
            }
            long skipped = request.getInputStream().skip(request.getPostIndex());
            assert (skipped == (long)request.getPostIndex());
            String data = this.ioUtils.toStringNoClose(request.getInputStream(), request.getContentLength());
            logger.finest(data);
            this.jsonDataSaver.saveJSONData(reportDir, data, unloadJSData, this.uriFileTranslator);
            if (!this.configuration.isSaveJSONOnly()) {
                this.copyJSSourceIntoReportDir(reportDir);
                this.ioService.generateJSCoverFilesForWebServer(reportDir, this.configuration.getVersion());
            }
            this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, "Coverage data stored at " + reportDir);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error saving coverage data", t);
            String message = String.format("Error saving coverage data. Try deleting JSON file at %s", reportDir);
            this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.TEXT_PLAIN, message);
        }
    }

    private void copyJSSourceIntoReportDir(File reportDir) throws IOException {
        if (this.configuration.isProxy()) {
            for (String jsURI : uris.keySet()) {
                File dest = new File(reportDir, Main.reportSrcSubDir + "/" + jsURI);
                logger.log(Level.FINE, "Copying {0} to {1}", new Object[]{jsURI, dest.getCanonicalPath()});
                this.ioUtils.copy(uris.get(jsURI), dest);
            }
        } else {
            for (String jsURI : uris.keySet()) {
                File src = new File(this.configuration.getDocumentRoot(), jsURI);
                File dest = new File(reportDir, Main.reportSrcSubDir + "/" + jsURI);
                logger.log(Level.FINE, "Copying {0} to {1}", new Object[]{jsURI, dest.getCanonicalPath()});
                this.ioUtils.copy(src, dest);
            }
        }
    }

    @Override
    protected void handleGet(HttpRequest request) throws IOException {
        String uri = request.getPath();
        try {
            if (uri.equals("/jscoverage.js")) {
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), this.ioService.generateJSCoverageServerJS());
            } else if (uri.startsWith("/jscoverage.html")) {
                String reportHTML = this.ioService.generateJSCoverageHtml(this.configuration.getVersion());
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), reportHTML);
            } else if (uri.startsWith("/jscoverage")) {
                this.sendResponse(HTTP_STATUS.HTTP_OK, request.getMime(), this.ioService.getResourceAsStream(uri));
            } else if (uri.endsWith(".js") && !this.configuration.skipInstrumentation(uri.substring(1)) && !request.skipInstrumentation()) {
                String jsInstrumented;
                if (this.configuration.isProxy()) {
                    String originalJS = this.proxyService.getUrl(request);
                    jsInstrumented = this.instrumenterService.instrumentJSForProxyServer(this.configuration, originalJS, uri);
                    uris.put(this.uriFileTranslator.convertUriToFile(uri).substring(1), originalJS);
                } else {
                    jsInstrumented = this.instrumenterService.instrumentJSForWebServer(this.configuration, new File(this.wwwRoot, uri), uri);
                    uris.put(uri.substring(1), null);
                }
                this.sendResponse(HTTP_STATUS.HTTP_OK, MIME.JS, jsInstrumented);
            } else if (this.configuration.isProxy()) {
                this.proxyService.handleProxyGet(request, this.os);
            } else {
                super.handleGet(request);
            }
        }
        catch (UriNotFound e) {
            this.sendResponse(HTTP_STATUS.HTTP_FILE_NOT_FOUND, MIME.TEXT_PLAIN, e.getMessage());
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.sendResponse(HTTP_STATUS.HTTP_INTERNAL_SERVER_ERROR, MIME.TEXT_PLAIN, stringWriter.toString());
        }
    }

    @Override
    protected void handleOther(String httpMethod, HttpRequest request) {
        if (this.configuration.isProxy()) {
            this.proxyService.handleProxyRequest(request, this.os, httpMethod);
        } else {
            super.handleOther(httpMethod, request);
        }
    }
}

