/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.util.Arrays;
import java.util.List;

public enum MIME {
    DEFAULT("application/octet-stream", new String[0]),
    CSS("text/css", "css"),
    ICO("image/x-icon", "ico"),
    JS("application/javascript", "js"),
    JSON("application/json", "json"),
    HTML("text/html", "htm", "html"),
    XML("application/xml", "xml"),
    GIF("image/gif", "gif"),
    JPG("image/jpeg", "jpg", "jpeg"),
    PDF("application/pdf", "pdf"),
    PNG("image/png", "png"),
    SVG("image/svg+xml", "svg"),
    TEXT_PLAIN("text/plain", "txt"),
    TTF("application/x-font-ttf", "ttf");

    private String contentType;
    private List<String> extensions;

    private MIME(String contentType, String ... extensions) {
        this.contentType = contentType;
        this.extensions = Arrays.asList(extensions);
    }

    public String getContentType() {
        return this.contentType;
    }

    public static MIME getMime(String extension) {
        if (extension == null) {
            return DEFAULT;
        }
        for (MIME mime : MIME.values()) {
            if (!mime.extensions.contains(extension.toLowerCase())) continue;
            return mime;
        }
        return DEFAULT;
    }
}

