/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import jscover.server.ConfigurationForServer;
import jscover.server.InstrumentingRequestHandler;
import jscover.util.IoUtils;
import jscover.util.LoggerUtils;

public class WebDaemon {
    private static final Logger logger = Logger.getLogger(WebDaemon.class.getName());
    private LoggerUtils loggerUtils = LoggerUtils.getInstance();
    private IoUtils ioUtils = IoUtils.getInstance();
    private ServerSocket serverSocket;
    public boolean running = true;

    public void start(ConfigurationForServer configuration) throws IOException, InterruptedException {
        this.loggerUtils.configureLogger(configuration.getLogLevel(), configuration.getReportDir());
        logger.log(Level.INFO, "Starting JSCover {0} HTTP Server, port {1,number,#}", new Object[]{configuration.getVersion(), configuration.getPort()});
        this.serverSocket = new ServerSocket(configuration.getPort());
        InstrumentingRequestHandler.uris.clear();
        while (this.running) {
            Socket socket = this.serverSocket.accept();
            new InstrumentingRequestHandler(socket, configuration).start();
        }
    }

    public void stop() {
        this.running = false;
        logger.log(Level.WARNING, "Stopping JSCover");
        this.ioUtils.closeQuietly(this.serverSocket);
    }
}

