/*
 * Decompiled with CFR 0.152.
 */
package jscover.stdout;

import java.io.File;
import jscover.ConfigurationCommon;

public class ConfigurationForStdOut
extends ConfigurationCommon {
    private File srcFile;

    public File getSrcFile() {
        return this.srcFile;
    }

    public static ConfigurationForStdOut parse(String[] args) {
        ConfigurationForStdOut configuration = new ConfigurationForStdOut();
        for (String arg : args) {
            configuration.parse(arg);
        }
        if (args.length < 2) {
            configuration.invalid = true;
            configuration.showHelp = true;
            return configuration;
        }
        if (!configuration.validSourceFile()) {
            configuration.setInvalid(String.format("Source file '%s' is invalid", configuration.srcFile));
        }
        configuration.compilerEnvirons.setLanguageVersion(configuration.JSVersion);
        return configuration;
    }

    public void parse(String arg) {
        if (super.parseArg(arg)) {
            return;
        }
        if (!arg.startsWith("-io")) {
            if (this.srcFile == null) {
                this.srcFile = new File(arg);
            } else {
                this.setInvalid(String.format("JSCover: Extra command line argument found '%s'", arg));
            }
        }
    }

    private boolean validSourceFile() {
        return this.srcFile.exists() && this.srcFile.isFile();
    }

    public String getHelpText() {
        return this.ioUtils.toString(this.getClass().getResourceAsStream("help.txt"));
    }
}

