/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        String message = record.getMessage();
        if (record.getParameters() != null && record.getParameters().length > 0) {
            message = MessageFormat.format(record.getMessage(), record.getParameters());
        }
        return this.getFormat(record, throwable, message);
    }

    private String getFormat(LogRecord record, String throwable, String message) {
        return String.format("%1$tY%1$tm%1$td %1$tk:%1$tM:%1$tS.%1$tL,%2$d,%3$s,\"%4$s\",%5$s,%6$s%n", new Date(record.getMillis()), record.getThreadID(), record.getLevel(), message, record.getLoggerName(), throwable);
    }
}

