/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jscover.util.ExceptionRecordingHandler;
import jscover.util.LogFormatter;

public class LoggerUtils {
    private static LoggerUtils loggerUtils = new LoggerUtils();
    private Formatter logFormatter = new LogFormatter();
    private ExceptionRecordingHandler exceptionRecordingHandler = new ExceptionRecordingHandler();

    private LoggerUtils() {
    }

    public static LoggerUtils getInstance() {
        return loggerUtils;
    }

    public boolean isExceptionThrown() {
        return this.exceptionRecordingHandler.isExceptionThrown();
    }

    public void configureLogger(Level level, File dir) {
        this.addExceptionRecorder();
        if (System.getProperty("java.util.logging.config.file") == null) {
            this.addProgrammaticLogging(level, dir);
        }
    }

    private void addProgrammaticLogging(Level level, File dir) {
        try {
            dir.mkdirs();
            File file = new File(dir, "jscover.log");
            if (file.exists()) {
                file.delete();
            }
            this.alterLoggers(level, file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void alterLoggers(Level level, File file) throws IOException {
        FileHandler fileTxt = new FileHandler(file.getAbsolutePath(), true);
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            String loggerName = names.nextElement();
            Logger logger = LogManager.getLogManager().getLogger(loggerName);
            logger.setLevel(level);
            logger.addHandler(fileTxt);
            Handler[] handlers = logger.getHandlers();
            for (int index = 0; index < handlers.length; ++index) {
                handlers[index].setLevel(level);
                handlers[index].setFormatter(this.logFormatter);
            }
        }
    }

    private void addExceptionRecorder() {
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            String loggerName = names.nextElement();
            Logger logger = LogManager.getLogManager().getLogger(loggerName);
            logger.addHandler(this.exceptionRecordingHandler);
        }
    }
}

