/*
 * Decompiled with CFR 0.152.
 */
package jscover.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jscover.util.UriFileTranslator;

public class UriFileTranslatorReg
implements UriFileTranslator {
    private static final Logger logger = Logger.getLogger(UriFileTranslatorReg.class.getName());
    private Pattern pattern;
    private String replacement;

    public UriFileTranslatorReg(Pattern pattern, String replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public String convertUriToFile(String uri) {
        String filePath = this.pattern.matcher(uri).replaceAll(this.replacement);
        logger.log(Level.FINE, "Translated path from ''{0}'' to ''{1}''", new Object[]{uri, filePath});
        return filePath;
    }

    @Override
    public boolean mutates() {
        return true;
    }
}

