/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jscover.Main;
import jscover.filesystem.ConfigurationForFS;
import jscover.maven.FileTestRunner;
import jscover.maven.JSCoverMojo;
import jscover.util.IoUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="jscover", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class FileMojo
extends JSCoverMojo {
    private IoUtils ioUtils = IoUtils.getInstance();
    @Parameter
    private File srcDir = new File("src");
    @Parameter
    protected final List<String> excludeArgs = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setSystemProperties();
        ConfigurationForFS config = this.getConfigurationForFS(this.srcDir, this.excludeArgs);
        config.validate();
        if (config.isInvalid()) {
            throw new MojoExecutionException("Invalid configuration");
        }
        if (!this.ioUtils.isSubDirectory(this.testDirectory, this.srcDir)) {
            throw new MojoExecutionException(String.format("'testDirectory' '%s' should be a sub-directory of 'srcDir' '%s'", this.testDirectory, this.srcDir));
        }
        Main main = new Main();
        main.initialize();
        main.runFileSystem(config);
        this.getLog().info((CharSequence)"Ran JSCover instrumentation");
        String relativeDirectory = this.ioUtils.getRelativePath(this.testDirectory, this.srcDir);
        File testDir = new File(this.reportDir, relativeDirectory);
        try {
            new FileTestRunner(this.getWebDriver(), this.getWebDriverRunner(), config, this.lineCoverageMinimum, this.branchCoverageMinimum, this.functionCoverageMinimum, this.reportLCOV, this.reportCoberturaXML).runTests(this.getTestFiles(testDir));
        }
        finally {
            this.stopWebClient();
        }
    }
}

