/*
 * Decompiled with CFR 0.152.
 */
package jscover.maven;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import jscover.filesystem.ConfigurationForFS;
import jscover.maven.JSCoverTestRunner;
import jscover.maven.WebDriverRunner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class FileTestRunner
extends JSCoverTestRunner {
    private Log log = new SystemStreamLog();
    private ConfigurationForFS config;

    public FileTestRunner(WebDriver webClient, WebDriverRunner webDriverRunner, ConfigurationForFS config, int lineCoverageMinimum, int branchCoverageMinimum, int functionCoverageMinimum, boolean reportLCOV, boolean reportCoberturaXML) {
        super(webClient, webDriverRunner, lineCoverageMinimum, branchCoverageMinimum, functionCoverageMinimum, reportLCOV, reportCoberturaXML);
        this.config = config;
    }

    public void runTests(List<File> testPages) throws MojoFailureException, MojoExecutionException {
        File jsonFile = new File(this.config.getDestDir() + "/jscoverage.json");
        if (jsonFile.exists()) {
            this.log.info((CharSequence)("Deleting JSON file " + jsonFile.getAbsolutePath()));
            jsonFile.delete();
        }
        if (this.config.isLocalStorage()) {
            String localStorageUrl = "file:///" + new File(this.config.getDestDir(), "jscoverage-clear-local-storage.html").getAbsolutePath().replaceAll("\\\\", "/");
            this.log.info((CharSequence)("Clearing local storage: " + localStorageUrl));
            this.webClient.get(localStorageUrl);
            for (File testPage : testPages) {
                this.runTestLocalStorage(this.ioUtils.getRelativePath(testPage, this.config.getDestDir()));
            }
            this.saveCoverageData();
            this.webClient.get("file:///" + new File(this.config.getDestDir(), "jscoverage.html").getAbsolutePath().replaceAll("\\\\", "/"));
        } else {
            this.webClient.get("file:///" + new File(this.config.getDestDir(), "jscoverage.html").getAbsolutePath().replaceAll("\\\\", "/"));
            for (File testPage : testPages) {
                this.runTestInFrames(this.ioUtils.getRelativePath(testPage, this.config.getDestDir()));
            }
            String handle = this.webClient.getWindowHandle();
            new WebDriverWait(this.webClient, 1L).until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)"browserIframe"));
            this.saveCoverageData();
            this.webClient.switchTo().window(handle);
        }
        this.verifyTotal();
        this.generateOtherReportFormats(this.config.getDestDir());
    }

    private void saveCoverageData() {
        String json = (String)((JavascriptExecutor)this.webClient).executeScript("return jscoverage_serializeCoverageToJSON();", new Object[0]);
        this.ioUtils.copy(json, new File(this.config.getDestDir(), "jscoverage.json"));
        File jscoverageJS = new File(this.config.getDestDir(), "jscoverage.js");
        String js = this.ioUtils.toString(jscoverageJS);
        this.ioUtils.copy(js + "\njscoverage_isReport = true;", jscoverageJS);
    }

    public void runTestLocalStorage(String testPage) throws MojoFailureException, MojoExecutionException {
        this.log.info((CharSequence)("Testing " + testPage));
        this.webClient.get("file:///" + new File(this.config.getDestDir(), testPage).getAbsolutePath().replaceAll("\\\\", "/"));
        this.webDriverRunner.waitForTestsToComplete(this.webClient);
        this.webDriverRunner.verifyTestsPassed(this.webClient);
        this.log.info((CharSequence)"...passed");
    }

    public void runTestInFrames(String testPage) throws MojoFailureException, MojoExecutionException {
        this.log.info((CharSequence)("Testing (without localStorage) " + testPage));
        this.webClient.findElement(By.id((String)"location")).clear();
        this.webClient.findElement(By.id((String)"location")).sendKeys(new CharSequence[]{testPage});
        this.webClient.findElement(By.id((String)"openInFrameButton")).click();
        String handle = this.webClient.getWindowHandle();
        new WebDriverWait(this.webClient, 1L).until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)"browserIframe"));
        this.webDriverRunner.waitForTestsToComplete(this.webClient);
        this.webDriverRunner.verifyTestsPassed(this.webClient);
        this.webClient.switchTo().window(handle);
        this.log.info((CharSequence)"...passed");
    }
}

