/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.ValueMatchingStrategy;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.ValuePattern;
import java.util.List;
import java.util.Map;
import java.util.Set;
import wiremock.com.google.common.collect.Iterables;
import wiremock.com.google.common.collect.Lists;
import wiremock.com.google.common.collect.Maps;
import wiremock.com.google.common.collect.Sets;

public class RequestPatternBuilder {
    private RequestMethod method;
    private UrlMatchingStrategy urlMatchingStrategy;
    private Map<String, ValueMatchingStrategy> headers = Maps.newLinkedHashMap();
    private Map<String, ValueMatchingStrategy> queryParameters = Maps.newLinkedHashMap();
    private Set<String> withoutHeaders = Sets.newHashSet();
    private List<ValueMatchingStrategy> bodyPatterns = Lists.newArrayList();

    public RequestPatternBuilder(RequestMethod method, UrlMatchingStrategy urlMatchingStrategy) {
        this.method = method;
        this.urlMatchingStrategy = urlMatchingStrategy;
    }

    public RequestPatternBuilder withHeader(String key, ValueMatchingStrategy headerMatchingStrategy) {
        this.headers.put(key, headerMatchingStrategy);
        return this;
    }

    public RequestPatternBuilder withQueryParam(String key, ValueMatchingStrategy queryParamMatchingStrategy) {
        this.queryParameters.put(key, queryParamMatchingStrategy);
        return this;
    }

    public RequestPatternBuilder withoutHeader(String key) {
        this.withoutHeaders.add(key);
        return this;
    }

    public RequestPatternBuilder withRequestBody(ValueMatchingStrategy bodyMatchingStrategy) {
        this.bodyPatterns.add(bodyMatchingStrategy);
        return this;
    }

    public static RequestPatternBuilder allRequests() {
        UrlMatchingStrategy matchAllUrls = new UrlMatchingStrategy();
        matchAllUrls.setUrlPattern(".*");
        return new RequestPatternBuilder(RequestMethod.ANY, matchAllUrls);
    }

    public RequestPattern build() {
        RequestPattern requestPattern = new RequestPattern();
        requestPattern.setMethod(this.method);
        this.urlMatchingStrategy.contributeTo(requestPattern);
        for (Map.Entry<String, ValueMatchingStrategy> entry : this.headers.entrySet()) {
            requestPattern.addHeader(entry.getKey(), entry.getValue().asValuePattern());
        }
        for (String string : this.withoutHeaders) {
            requestPattern.addHeader(string, ValuePattern.absent());
        }
        for (Map.Entry entry : this.queryParameters.entrySet()) {
            requestPattern.addQueryParam((String)entry.getKey(), ((ValueMatchingStrategy)entry.getValue()).asValuePattern());
        }
        if (!this.bodyPatterns.isEmpty()) {
            requestPattern.setBodyPatterns(Lists.newArrayList(Iterables.transform(this.bodyPatterns, ValueMatchingStrategy.toValuePattern)));
        }
        return requestPattern;
    }
}

