/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.http.QueryParameter;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import wiremock.com.google.common.base.Splitter;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.ImmutableListMultimap;
import wiremock.com.google.common.collect.Maps;

public class Urls {
    public static Map<String, QueryParameter> splitQuery(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        Iterable<String> pairs = Splitter.on('&').split(query);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String queryElement : pairs) {
            int firstEqualsIndex = queryElement.indexOf(61);
            if (firstEqualsIndex == -1) {
                builder.putAll((Object)queryElement, new String[]{""});
                continue;
            }
            String key = queryElement.substring(0, firstEqualsIndex);
            String value = queryElement.substring(firstEqualsIndex + 1);
            builder.putAll((Object)key, new String[]{value});
        }
        return Maps.transformEntries(builder.build().asMap(), new Maps.EntryTransformer<String, Collection<String>, QueryParameter>(){

            @Override
            public QueryParameter transformEntry(String key, Collection<String> values) {
                return new QueryParameter(key, ImmutableList.copyOf(values));
            }
        });
    }

    public static Map<String, QueryParameter> splitQuery(URI uri) {
        if (uri == null) {
            return Collections.emptyMap();
        }
        return Urls.splitQuery(uri.getQuery());
    }
}

