/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty6;

import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.jetty6.ActiveSocket;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLException;
import wiremock.org.mortbay.jetty.security.SslSocketConnector;
import wiremock.org.mortbay.log.Log;

class DelayableSslSocketConnector
extends SslSocketConnector {
    private final RequestDelayControl requestDelayControl;

    DelayableSslSocketConnector(RequestDelayControl requestDelayControl) {
        this.requestDelayControl = requestDelayControl;
    }

    @Override
    public void accept(int acceptorID) throws IOException, InterruptedException {
        try {
            Socket socket;
            block6: {
                socket = this._serverSocket.accept();
                try {
                    this.requestDelayControl.delayIfRequired();
                }
                catch (InterruptedException e) {
                    if (this.isStopping() || this.isStopped()) break block6;
                    Thread.interrupted();
                }
            }
            this.configure(socket);
            SslSocketConnector.SslConnection connection = new SslSocketConnector.SslConnection(socket){

                @Override
                public void run() {
                    ActiveSocket.set(socket);
                    super.run();
                    ActiveSocket.clear();
                }
            };
            connection.dispatch();
        }
        catch (SSLException e) {
            Log.warn(e);
            try {
                this.stop();
            }
            catch (Exception e2) {
                Log.warn(e2);
                throw new IllegalStateException(e2.getMessage());
            }
        }
    }
}

