/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.ReportBodyProvider;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.UrlEncodedContent;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;

class AwqlReportBodyProvider
implements ReportBodyProvider {
    private static final String REPORT_QUERY_KEY = "__rdquery";
    private static final String FORMAT_KEY = "__fmt";
    private final String reportQuery;
    private final String format;

    public AwqlReportBodyProvider(String reportQuery, String format) {
        this.reportQuery = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)reportQuery), (Object)"Null or empty report query");
        this.format = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)format), (Object)"Null or empty format");
    }

    public HttpContent getHttpContent() {
        HashMap data = Maps.newHashMap();
        data.put(REPORT_QUERY_KEY, this.reportQuery);
        data.put(FORMAT_KEY, this.format);
        return new UrlEncodedContent((Object)data);
    }
}

